/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.esaulpaugh.headlong.abi.Function;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.EvmHookCall;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.hooks.HookExecution;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.HookDispatchUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseCryptoHandler;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.AdjustFungibleTokenChangesStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.AdjustHbarChangesStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.AssociateTokenRecipientsStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.CustomFeeAssessmentStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.EnsureAliasesStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.NFTOwnersChangeStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.ReplaceAliasesWithIDsInOp;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContextImpl;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCalls;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCallsFactory;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookInvocation;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HooksABI;
import com.hedera.node.app.service.token.impl.util.CryptoTransferValidationHelper;
import com.hedera.node.app.service.token.impl.validators.CryptoTransferValidator;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.config.data.HooksConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TransferExecutor
extends BaseTokenHandler {
    private final CryptoTransferValidator validator;
    private final HookCallsFactory hookCallsFactory;
    private final EntityIdFactory entityIdFactory;

    @Inject
    public TransferExecutor(@NonNull CryptoTransferValidator validator, @NonNull HookCallsFactory hookCallsFactory, @NonNull EntityIdFactory entityIdFactory) {
        this.validator = Objects.requireNonNull(validator);
        this.hookCallsFactory = Objects.requireNonNull(hookCallsFactory);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    protected void preHandle(PreHandleContext context, CryptoTransferTransactionBody op) throws PreCheckException {
        this.preHandle(context, op, OptionalKeyCheck.RECEIVER_KEY_IS_REQUIRED);
    }

    private void preHandle(@NonNull PreHandleContext context, @NonNull CryptoTransferTransactionBody op, @NonNull OptionalKeyCheck receiverKeyCheck) throws PreCheckException {
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        List tokenTransfers = op.tokenTransfers();
        List hbarTransfers = op.transfersOrElse(TransferList.DEFAULT).accountAmounts();
        for (TokenTransferList transfers : tokenTransfers) {
            ReadableTokenStore.TokenMetadata tokenMeta = tokenStore.getTokenMeta(transfers.tokenOrElse(TokenID.DEFAULT));
            if (tokenMeta == null) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
            }
            this.checkFungibleTokenTransfers(transfers.transfers(), context, accountStore, false, receiverKeyCheck);
            this.checkNftTransfers(transfers.nftTransfers(), context, tokenMeta, op, accountStore, receiverKeyCheck);
        }
        this.checkFungibleTokenTransfers(hbarTransfers, context, accountStore, true, OptionalKeyCheck.RECEIVER_KEY_IS_REQUIRED);
    }

    protected void preHandleWithOptionalReceiverSignature(PreHandleContext context, CryptoTransferTransactionBody op) throws PreCheckException {
        this.preHandle(context, op, OptionalKeyCheck.RECEIVER_KEY_IS_OPTIONAL);
    }

    protected void executeCryptoTransfer(TransactionBody txn, TransferContextImpl transferContext, HandleContext context, CryptoTransferStreamBuilder recordBuilder) {
        this.executeCryptoTransfer(txn, transferContext, context, recordBuilder, false);
    }

    protected void executeCryptoTransfer(TransactionBody txn, TransferContextImpl transferContext, HandleContext context, CryptoTransferStreamBuilder recordBuilder, boolean skipCustomFee) {
        boolean hasHooks;
        AccountID topLevelPayer = context.payer();
        transferContext.validateHbarAllowances();
        HooksConfig hooksConfig = (HooksConfig)context.configuration().getConfigData(HooksConfig.class);
        CryptoTransferTransactionBody replacedOp = this.ensureAndReplaceAliasesInOp(txn, transferContext, this.validator);
        List<CryptoTransferTransactionBody> txns = List.of(replacedOp);
        if (!skipCustomFee) {
            txns = new CustomFeeAssessmentStep(replacedOp).assessCustomFees(transferContext);
        }
        HookCalls hookCalls = (hasHooks = HookUtils.hasHookExecutions((CryptoTransferTransactionBody)replacedOp)) ? this.hookCallsFactory.from(transferContext.getHandleContext(), replacedOp, transferContext.getItemizedAssessedFees()) : null;
        Counter numAttemptedHookCalls = new Counter();
        if (hasHooks) {
            try {
                this.dispatchHookCalls(hookCalls.context(), hookCalls.preOnlyHooks(), transferContext.getHandleContext(), HooksABI.FN_ALLOW, numAttemptedHookCalls);
                this.dispatchHookCalls(hookCalls.context(), hookCalls.prePostHooks(), transferContext.getHandleContext(), HooksABI.FN_ALLOW_PRE, numAttemptedHookCalls);
            }
            catch (HandleException e) {
                throw new HandleException(e.getStatus(), ctx -> this.refundHookFee(context, (FeeCharging.Context)ctx, hookCalls, numAttemptedHookCalls.get(), hooksConfig, topLevelPayer));
            }
        }
        for (CryptoTransferTransactionBody t : txns) {
            new AssociateTokenRecipientsStep(t).doIn(transferContext);
            new AdjustHbarChangesStep(t, topLevelPayer, this.entityIdFactory).doIn(transferContext);
            new AdjustFungibleTokenChangesStep(t.tokenTransfers(), topLevelPayer).doIn(transferContext);
            new NFTOwnersChangeStep(t.tokenTransfers(), topLevelPayer).doIn(transferContext);
        }
        if (hasHooks) {
            try {
                this.dispatchHookCalls(hookCalls.context(), hookCalls.prePostHooks(), transferContext.getHandleContext(), HooksABI.FN_ALLOW_POST, numAttemptedHookCalls);
            }
            catch (HandleException e) {
                throw new HandleException(e.getStatus(), ctx -> this.refundHookFee(context, (FeeCharging.Context)ctx, hookCalls, numAttemptedHookCalls.get(), hooksConfig, topLevelPayer));
            }
        }
        if (!transferContext.getAutomaticAssociations().isEmpty()) {
            transferContext.getAutomaticAssociations().forEach(arg_0 -> ((CryptoTransferStreamBuilder)recordBuilder).addAutomaticTokenAssociation(arg_0));
        }
        if (!transferContext.getAssessedCustomFees().isEmpty()) {
            recordBuilder.assessedCustomFees(transferContext.getAssessedCustomFees());
        }
    }

    private void refundHookFee(@NonNull HandleContext context, @NonNull FeeCharging.Context ctx, @NonNull HookCalls hookCalls, int numAttemptedHookCalls, @NonNull HooksConfig hooksConfig, @NonNull AccountID payerId) {
        long tinycentsToRefund = this.getFeesToRefund(hookCalls, numAttemptedHookCalls, hooksConfig.hookInvocationCostTinyCents(), context.getGasPriceInTinycents());
        long refundInTinybars = ((FeeContext)context).tinybarsFromTinycents(tinycentsToRefund);
        ctx.refund(payerId, new Fees(0L, 0L, refundInTinybars));
    }

    private long getFeesToRefund(HookCalls hookCalls, int numAttemptedHookCalls, long hookInvocationCostTinyCents, long gasPriceInTinyCents) {
        List<HookInvocation> preOnlyHooks = hookCalls.preOnlyHooks();
        List<HookInvocation> prePostHooks = hookCalls.prePostHooks();
        int totalHookCalls = preOnlyHooks.size() + prePostHooks.size() * 2;
        if (numAttemptedHookCalls == totalHookCalls) {
            return 0L;
        }
        long gasToRefund = 0L;
        int invocationsToRefund = 0;
        int invocationIndex = 0;
        for (HookInvocation hook : preOnlyHooks) {
            if (invocationIndex >= numAttemptedHookCalls) {
                gasToRefund += hook.gasLimit();
                ++invocationsToRefund;
            }
            ++invocationIndex;
        }
        for (HookInvocation hook : prePostHooks) {
            if (invocationIndex >= numAttemptedHookCalls) {
                gasToRefund += hook.gasLimit();
                ++invocationsToRefund;
            }
            ++invocationIndex;
        }
        for (HookInvocation hook : prePostHooks) {
            if (invocationIndex >= numAttemptedHookCalls) {
                gasToRefund += hook.gasLimit();
                ++invocationsToRefund;
            }
            ++invocationIndex;
        }
        long feeToRefund = CommonUtils.clampedMultiply((long)invocationsToRefund, (long)hookInvocationCostTinyCents);
        long gasRefund = CommonUtils.clampedMultiply((long)gasToRefund, (long)gasPriceInTinyCents);
        return CommonUtils.clampedAdd((long)feeToRefund, (long)gasRefund);
    }

    protected void executeAirdropCryptoTransfer(@NonNull HandleContext context, @NonNull List<TokenTransferList> tokenTransferList, @NonNull CryptoTransferStreamBuilder recordBuilder) {
        CryptoTransferTransactionBody cryptoTransferBody = CryptoTransferTransactionBody.newBuilder().tokenTransfers(tokenTransferList).build();
        TransactionBody syntheticCryptoTransferTxn = TransactionBody.newBuilder().cryptoTransfer(cryptoTransferBody).build();
        TransferContextImpl transferContext = new TransferContextImpl(context, cryptoTransferBody, true);
        this.executeCryptoTransferWithoutCustomFee(syntheticCryptoTransferTxn, transferContext, context, recordBuilder);
    }

    protected CryptoTransferTransactionBody chargeCustomFeeForAirdrops(TransactionBody txn, TransferContextImpl transferContext) {
        CustomFeeAssessmentStep customFeeStep = new CustomFeeAssessmentStep(txn.cryptoTransferOrThrow());
        List<CryptoTransferTransactionBody> transferBodies = customFeeStep.assessCustomFees(transferContext);
        AccountID topLevelPayer = transferContext.getHandleContext().payer();
        int n = transferBodies.size();
        for (int i = 1; i < n; ++i) {
            AdjustHbarChangesStep adjustHbarChangesStep = new AdjustHbarChangesStep(transferBodies.get(i), topLevelPayer, this.entityIdFactory);
            adjustHbarChangesStep.doIn(transferContext);
            AdjustFungibleTokenChangesStep adjustFungibleChangesStep = new AdjustFungibleTokenChangesStep(transferBodies.get(i).tokenTransfers(), topLevelPayer);
            adjustFungibleChangesStep.doIn(transferContext);
        }
        return transferBodies.getFirst();
    }

    protected void executeCryptoTransferWithoutCustomFee(TransactionBody txn, TransferContextImpl transferContext, HandleContext context, CryptoTransferStreamBuilder recordBuilder) {
        this.executeCryptoTransfer(txn, transferContext, context, recordBuilder, true);
    }

    private CryptoTransferTransactionBody ensureAndReplaceAliasesInOp(@NonNull TransactionBody txn, @NonNull TransferContextImpl transferContext, @NonNull CryptoTransferValidator validator) throws HandleException {
        CryptoTransferTransactionBody op = txn.cryptoTransferOrThrow();
        this.ensureExistenceOfAliasesOrCreate(op, transferContext);
        CryptoTransferTransactionBody replacedOp = new ReplaceAliasesWithIDsInOp().replaceAliasesWithIds(op, transferContext);
        try {
            validator.pureChecks(replacedOp);
        }
        catch (PreCheckException e) {
            throw new HandleException(e.responseCode());
        }
        return replacedOp;
    }

    private void ensureExistenceOfAliasesOrCreate(@NonNull CryptoTransferTransactionBody op, @NonNull TransferContextImpl transferContext) {
        EnsureAliasesStep ensureAliasExistence = new EnsureAliasesStep(op);
        ensureAliasExistence.doIn(transferContext);
    }

    private void dispatchHookCalls(@NonNull HookContext hookContext, @NonNull List<HookInvocation> hookInvocations, @NonNull HandleContext handleContext, @NonNull Function function, @NonNull Counter numAttemptedHookCalls) {
        boolean isolated = hookInvocations.size() == 1;
        for (HookInvocation hookInvocation : hookInvocations) {
            byte[] calldata;
            try {
                calldata = HooksABI.encode(hookInvocation, hookContext, function);
            }
            catch (Exception e) {
                throw new HandleException(ResponseCodeEnum.INVALID_HOOK_CALL);
            }
            HookExecution execution = HookExecution.newBuilder().hookEntityId(HookEntityId.newBuilder().accountId(hookInvocation.ownerId()).build()).call(HookCall.newBuilder().evmHookCall(EvmHookCall.newBuilder().gasLimit(hookInvocation.gasLimit()).data(Bytes.wrap((byte[])calldata)).build()).hookId(hookInvocation.hookId()).build()).build();
            numAttemptedHookCalls.increment();
            HookDispatchUtils.dispatchExecution((HandleContext)handleContext, (HookExecution)execution, (Function)function, (EntityIdFactory)this.entityIdFactory, (boolean)isolated);
        }
    }

    private void checkFungibleTokenTransfers(@NonNull List<AccountAmount> transfers, @NonNull PreHandleContext ctx, @NonNull ReadableAccountStore accountStore, boolean hbarTransfer, @NonNull OptionalKeyCheck receiverKeyCheck) throws PreCheckException {
        for (AccountAmount accountAmount : transfers) {
            boolean isDebit;
            AccountID accountId = Validations.validateAccountID((AccountID)accountAmount.accountIDOrElse(AccountID.DEFAULT), null);
            Account account = accountStore.getAliasedAccountById(accountId);
            boolean isCredit = accountAmount.amount() > 0L;
            boolean bl = isDebit = accountAmount.amount() < 0L;
            if (account != null) {
                boolean usesHook;
                if (BaseCryptoHandler.isStakingAccount(ctx.configuration(), account.accountId()) && (isDebit || isCredit && !hbarTransfer)) {
                    throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
                }
                boolean bl2 = usesHook = accountAmount.hasPreTxAllowanceHook() || accountAmount.hasPrePostTxAllowanceHook();
                if (isDebit && !accountAmount.isApproval() && !usesHook) {
                    if (HapiUtils.isHollow((Account)account)) {
                        ctx.requireSignatureForHollowAccount(account);
                        continue;
                    }
                    ctx.requireKeyOrThrow(account.key(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
                    continue;
                }
                if (!isCredit || !account.receiverSigRequired()) continue;
                if (receiverKeyCheck == OptionalKeyCheck.RECEIVER_KEY_IS_OPTIONAL || usesHook) {
                    ctx.optionalKey(account.keyOrThrow());
                    continue;
                }
                ctx.requireKeyOrThrow(account.key(), ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
                continue;
            }
            if (!(hbarTransfer ? !isCredit || !AliasUtils.isAlias((AccountID)accountId) : isDebit)) continue;
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
    }

    private void checkNftTransfers(List<NftTransfer> nftTransfersList, PreHandleContext meta, ReadableTokenStore.TokenMetadata tokenMeta, CryptoTransferTransactionBody op, ReadableAccountStore accountStore, OptionalKeyCheck receiverKeyCheck) throws PreCheckException {
        for (NftTransfer nftTransfer : nftTransfersList) {
            AccountID senderId = nftTransfer.senderAccountIDOrElse(AccountID.DEFAULT);
            Validations.validateAccountID((AccountID)senderId, null);
            CryptoTransferValidationHelper.checkSender(senderId, nftTransfer, meta, accountStore);
            AccountID receiverId = nftTransfer.receiverAccountIDOrElse(AccountID.DEFAULT);
            Validations.validateAccountID((AccountID)receiverId, null);
            CryptoTransferValidationHelper.checkReceiver(receiverId, senderId, nftTransfer, meta, tokenMeta, op, accountStore, receiverKeyCheck);
        }
    }

    public static enum OptionalKeyCheck {
        RECEIVER_KEY_IS_OPTIONAL,
        RECEIVER_KEY_IS_REQUIRED;

    }

    private static class Counter {
        private int n;

        private Counter() {
        }

        public void increment() {
            ++this.n;
        }

        public int get() {
            return this.n;
        }
    }

    public record HookInvocations(List<HookInvocation> pre, List<HookInvocation> post) {
    }
}

