/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.TokenAttributesValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenCreateValidator {
    private final TokenAttributesValidator tokenAttributesValidator;

    @Inject
    public TokenCreateValidator(@NonNull TokenAttributesValidator tokenAttributesValidator) {
        this.tokenAttributesValidator = tokenAttributesValidator;
    }

    public void pureChecks(@NonNull TokenCreateTransactionBody op) throws PreCheckException {
        Objects.requireNonNull(op);
        long initialSupply = op.initialSupply();
        long maxSupply = op.maxSupply();
        int decimals = op.decimals();
        TokenSupplyType supplyType = op.supplyType();
        TokenType tokenType = op.tokenType();
        this.validateTokenType(tokenType, initialSupply, decimals);
        this.validateSupplyType(supplyType, maxSupply);
        PreCheckException.validateFalsePreCheck((maxSupply > 0L && initialSupply > maxSupply ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_INITIAL_SUPPLY);
        PreCheckException.validateTruePreCheck((boolean)op.hasTreasury(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
        if (tokenType == TokenType.NON_FUNGIBLE_UNIQUE) {
            PreCheckException.validateTruePreCheck((boolean)op.hasSupplyKey(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_SUPPLY_KEY);
        }
        if (op.freezeDefault()) {
            PreCheckException.validateTruePreCheck((boolean)op.hasFreezeKey(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_FREEZE_KEY);
        }
    }

    public void validate(@NonNull HandleContext context, @NonNull ReadableAccountStore accountStore, @NonNull TokenCreateTransactionBody op, @NonNull TokensConfig config) {
        TokenHandlerHelper.getIfUsableWithTreasury(op.treasuryOrElse(AccountID.DEFAULT), accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
        context.attributeValidator().validateMemo(op.memo());
        this.tokenAttributesValidator.validateTokenSymbol(op.symbol(), config);
        this.tokenAttributesValidator.validateTokenName(op.name(), config);
        this.tokenAttributesValidator.validateTokenKeys(op.hasAdminKey(), op.adminKey(), op.hasKycKey(), op.kycKey(), op.hasWipeKey(), op.wipeKey(), op.hasSupplyKey(), op.supplyKey(), op.hasFreezeKey(), op.freezeKey(), op.hasFeeScheduleKey(), op.feeScheduleKey(), op.hasPauseKey(), op.pauseKey(), op.hasMetadataKey(), op.metadataKey());
        this.tokenAttributesValidator.validateTokenMetadata(op.metadata(), config);
        HandleException.validateTrue((op.customFees().size() <= config.maxCustomFeesAllowed() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG);
    }

    private void validateTokenType(@NonNull TokenType type, long initialSupply, int decimals) throws PreCheckException {
        PreCheckException.validateTruePreCheck((type == TokenType.FUNGIBLE_COMMON || type == TokenType.NON_FUNGIBLE_UNIQUE ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        if (type == TokenType.FUNGIBLE_COMMON) {
            PreCheckException.validateTruePreCheck((initialSupply >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_INITIAL_SUPPLY);
            PreCheckException.validateTruePreCheck((decimals >= 0 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_DECIMALS);
        } else {
            PreCheckException.validateTruePreCheck((initialSupply == 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_INITIAL_SUPPLY);
            PreCheckException.validateTruePreCheck((decimals == 0 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_DECIMALS);
        }
    }

    private void validateSupplyType(TokenSupplyType supplyType, long maxSupply) throws PreCheckException {
        PreCheckException.validateTruePreCheck((supplyType == TokenSupplyType.INFINITE || supplyType == TokenSupplyType.FINITE ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        if (supplyType == TokenSupplyType.INFINITE) {
            PreCheckException.validateTruePreCheck((maxSupply == 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_MAX_SUPPLY);
        } else {
            PreCheckException.validateTruePreCheck((maxSupply > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_MAX_SUPPLY);
        }
    }

    public void validateAssociation(@NonNull EntitiesConfig entitiesConfig, @NonNull TokensConfig tokensConfig, @NonNull Account account, @NonNull Token token, @NonNull WritableTokenRelationStore tokenRelStore) {
        HandleException.validateFalse((entitiesConfig.limitTokenAssociations() && account.numberAssociations() + 1 > tokensConfig.maxPerAccount() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED);
        HandleException.validateTrue((tokenRelStore.get(account.accountId(), token.tokenId()) == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT);
    }
}

