/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;

public class AggregateEventCreationRules
implements EventCreationRule {
    private final List<EventCreationRule> rules;
    private EventCreationStatus mostRecentStatus = EventCreationStatus.RATE_LIMITED;

    public static AggregateEventCreationRules of(@NonNull List<EventCreationRule> rules) {
        return new AggregateEventCreationRules(rules);
    }

    private AggregateEventCreationRules(@NonNull List<EventCreationRule> rules) {
        this.rules = Objects.requireNonNull(rules);
    }

    @Override
    public boolean isEventCreationPermitted() {
        for (EventCreationRule rule : this.rules) {
            if (rule.isEventCreationPermitted()) continue;
            this.mostRecentStatus = rule.getEventCreationStatus();
            return false;
        }
        return true;
    }

    @Override
    public void eventWasCreated() {
        for (EventCreationRule rule : this.rules) {
            rule.eventWasCreated();
        }
    }

    @Override
    @NonNull
    public EventCreationStatus getEventCreationStatus() {
        return this.mostRecentStatus;
    }
}

