/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import com.swirlds.metrics.impl.AtomicDouble;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public class DefaultDoubleGauge
extends AbstractMetric
implements DoubleGauge {
    private final AtomicDouble value;

    public DefaultDoubleGauge(@NonNull DoubleGauge.Config config) {
        super((MetricConfig<?, ?>)config);
        this.value = new AtomicDouble(config.getInitialValue());
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.get()));
    }

    public double get() {
        return this.value.get();
    }

    public void set(double newValue) {
        this.value.set(newValue);
    }

    public void add(double change) {
        this.value.addAndGet(change);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.value.get()).toString();
    }
}

