/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.StateDefinition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;

public abstract class Schema<V>
implements Comparable<Schema<V>> {
    private final V version;
    private final Comparator<V> versionComparator;

    protected Schema(@NonNull V version, @NonNull Comparator<V> versionComparator) {
        this.version = Objects.requireNonNull(version);
        this.versionComparator = Objects.requireNonNull(versionComparator);
    }

    @NonNull
    public V getVersion() {
        return this.version;
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Collections.emptySet();
    }

    @NonNull
    public Set<StateDefinition> statesToCreate(@NonNull Configuration configuration) {
        return this.statesToCreate();
    }

    public void migrate(@NonNull MigrationContext<V> ctx) {
        Objects.requireNonNull(ctx);
    }

    @NonNull
    public Set<Integer> statesToRemove() {
        return Collections.emptySet();
    }

    public void restart(@NonNull MigrationContext<V> ctx) {
        Objects.requireNonNull(ctx);
    }

    @Override
    public int compareTo(Schema<V> o) {
        return this.versionComparator.compare(this.version, o.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }
}

