/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isapprovedforall;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.isapprovedforall.IsApprovedForAllCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IsApprovedForAllTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod CLASSIC_IS_APPROVED_FOR_ALL = SystemContractMethod.declare("isApprovedForAll(address,address,address)", "(int64,bool)").withCategories(SystemContractMethod.Category.TOKEN_QUERY, SystemContractMethod.Category.APPROVAL);
    public static final SystemContractMethod ERC_IS_APPROVED_FOR_ALL = SystemContractMethod.declare("isApprovedForAll(address,address)", "(bool)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.TOKEN_QUERY, SystemContractMethod.Category.APPROVAL);

    @Inject
    public IsApprovedForAllTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(CLASSIC_IS_APPROVED_FOR_ALL, ERC_IS_APPROVED_FOR_ALL);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(CLASSIC_IS_APPROVED_FOR_ALL, ERC_IS_APPROVED_FOR_ALL);
    }

    public IsApprovedForAllCall callFrom(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(ERC_IS_APPROVED_FOR_ALL)) {
            Tuple args = ERC_IS_APPROVED_FOR_ALL.decodeCall(attempt.input().toArrayUnsafe());
            return new IsApprovedForAllCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.redirectToken(), (Address)args.get(0), (Address)args.get(1), true);
        }
        Tuple args = CLASSIC_IS_APPROVED_FOR_ALL.decodeCall(attempt.input().toArrayUnsafe());
        Token token = attempt.linkedToken(ConversionUtils.fromHeadlongAddress((Address)args.get(0)));
        return new IsApprovedForAllCall(attempt.systemContractGasCalculator(), attempt.enhancement(), token, (Address)args.get(1), (Address)args.get(2), false);
    }
}

