/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state.hooks;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import com.hedera.node.app.service.contract.impl.state.EvmFrameStateFactory;
import com.hedera.node.app.service.contract.impl.state.hooks.HookEvmFrameState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hyperledger.besu.evm.code.CodeFactory;

public class HookEvmFrameStateFactory
implements EvmFrameStateFactory {
    private final HederaOperations hederaOperations;
    private final HederaNativeOperations hederaNativeOperations;
    private final CodeFactory codeFactory;
    private final EvmHookState hook;

    public HookEvmFrameStateFactory(@NonNull HederaOperations hederaOperations, @NonNull HederaNativeOperations hederaNativeOperations, @NonNull CodeFactory codeFactory, @NonNull EvmHookState hook) {
        this.hederaOperations = Objects.requireNonNull(hederaOperations);
        this.hederaNativeOperations = Objects.requireNonNull(hederaNativeOperations);
        this.codeFactory = Objects.requireNonNull(codeFactory);
        this.hook = Objects.requireNonNull(hook);
    }

    @Override
    public EvmFrameState get() {
        return new HookEvmFrameState(this.hederaNativeOperations, this.hederaOperations.getStore(), this.hederaNativeOperations.writableEvmHookStore(), this.codeFactory, this.hook);
    }

    @Override
    public AccountID hookRentPayerId() {
        return this.hook.hookIdOrThrow().entityIdOrThrow().accountIdOrThrow();
    }
}

