/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.crypto;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import java.util.List;
import java.util.concurrent.Future;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;

public interface MerkleCryptography {
    default public Hash digestSync(MerkleNode node) {
        return this.digestSync(node, Cryptography.DEFAULT_DIGEST_TYPE);
    }

    public Hash digestSync(MerkleInternal var1, boolean var2);

    public Hash digestSync(MerkleInternal var1, List<Hash> var2, boolean var3);

    public Hash digestSync(MerkleLeaf var1);

    default public Hash digestSync(MerkleNode node, DigestType digestType) {
        if (node.isLeaf()) {
            return this.digestSync(node.asLeaf());
        }
        MerkleInternal node1 = node.asInternal();
        return this.digestSync(node1, true);
    }

    public Hash digestTreeSync(MerkleNode var1);

    public Future<Hash> digestTreeAsync(MerkleNode var1);
}

