/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.route;

import com.swirlds.base.formatting.StringFormattingUtils;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteFactory;
import com.swirlds.common.merkle.route.MerkleRouteFormatException;
import java.util.ArrayList;

public final class MerkleRouteUtils {
    private MerkleRouteUtils() {
    }

    public static String merkleRouteToPathFormat(MerkleRoute route) {
        StringBuilder sb = new StringBuilder("/");
        StringFormattingUtils.formattedList((StringBuilder)sb, route.iterator(), (String)"/");
        return sb.toString();
    }

    public static MerkleRoute pathFormatToMerkleRoute(String path) {
        return MerkleRouteUtils.pathFormatToMerkleRoute(MerkleRouteFactory.getEmptyRoute(), path);
    }

    public static MerkleRoute pathFormatToMerkleRoute(MerkleRoute currentPath, String path) {
        String[] pathElements;
        if (path.isEmpty()) {
            return currentPath;
        }
        boolean isAbsolute = path.charAt(0) == '/';
        MerkleRoute root = isAbsolute ? MerkleRouteFactory.getEmptyRoute() : currentPath;
        ArrayList<String> steps = new ArrayList<String>();
        root.forEach(step -> steps.add(Integer.toString(step)));
        for (String pathElement : pathElements = path.split("/")) {
            if (pathElement.isEmpty() || pathElement.equals(".")) continue;
            steps.add(pathElement);
        }
        for (int i = 0; i < steps.size(); ++i) {
            if (!((String)steps.get(i)).equals("..")) continue;
            if (i == 0) {
                throw new MerkleRouteFormatException("can not use '..' to go above root");
            }
            steps.remove(i);
            steps.remove(i - 1);
            i -= 2;
        }
        ArrayList<Integer> integerSteps = new ArrayList<Integer>(steps.size());
        for (String step2 : steps) {
            try {
                integerSteps.add(Integer.parseInt(step2));
            }
            catch (NumberFormatException e) {
                throw new MerkleRouteFormatException("invalid step: " + step2);
            }
        }
        return MerkleRouteFactory.getEmptyRoute().extendRoute(integerSteps);
    }
}

