/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pces;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.pces.PcesFile;
import org.hiero.consensus.pces.PcesFileVersion;
import org.hiero.consensus.pces.PcesFileWriter;
import org.hiero.consensus.pces.PcesFileWriterType;

public class PcesMutableFile {
    private final PcesFile descriptor;
    private final PcesFileWriter writer;
    private long highestAncientIdentifierInFile;

    PcesMutableFile(@NonNull PcesFile descriptor, @NonNull PcesFileWriterType pcesFileWriterType) throws IOException {
        if (Files.exists(descriptor.getPath(), new LinkOption[0])) {
            throw new IOException("File " + String.valueOf(descriptor.getPath()) + " already exists");
        }
        Files.createDirectories(descriptor.getPath().getParent(), new FileAttribute[0]);
        this.descriptor = descriptor;
        this.writer = pcesFileWriterType.createWriter(descriptor.getPath());
        this.writer.writeVersion(PcesFileVersion.currentVersionNumber());
        this.highestAncientIdentifierInFile = descriptor.getLowerBound();
    }

    public boolean canContain(long ancientIdentifier) {
        return this.descriptor.canContain(ancientIdentifier);
    }

    public long writeEvent(PlatformEvent event) throws IOException {
        if (!this.descriptor.canContain(event.getBirthRound())) {
            throw new IllegalStateException("Cannot write event " + String.valueOf(event.getHash()) + " with ancient indicator " + event.getBirthRound() + " to file " + String.valueOf(this.descriptor));
        }
        long size = this.writer.writeEvent(event.getGossipEvent());
        this.highestAncientIdentifierInFile = Math.max(this.highestAncientIdentifierInFile, event.getBirthRound());
        return size;
    }

    public PcesFile compressSpan(long upperBoundInPreviousFile) {
        if (this.highestAncientIdentifierInFile == this.descriptor.getUpperBound()) {
            return this.descriptor;
        }
        PcesFile newDescriptor = this.descriptor.buildFileWithCompressedSpan(Math.max(this.highestAncientIdentifierInFile, upperBoundInPreviousFile));
        try {
            Files.move(this.descriptor.getPath(), newDescriptor.getPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return newDescriptor;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void sync() throws IOException {
        this.writer.sync();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public long fileSize() {
        return this.writer.fileSize();
    }

    public long getUtilizedSpan() {
        return this.highestAncientIdentifierInFile - this.descriptor.getLowerBound();
    }

    public long getUnUtilizedSpan() {
        return this.descriptor.getUpperBound() - this.highestAncientIdentifierInFile;
    }

    public long getSpan() {
        return this.descriptor.getUpperBound() - this.descriptor.getLowerBound();
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

