/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractCreateOperation;

public class Create2Operation
extends AbstractCreateOperation {
    private static final Bytes PREFIX = Bytes.fromHexString((CharSequence)"0xFF");

    public Create2Operation(GasCalculator gasCalculator) {
        super(245, "CREATE2", 4, 1, gasCalculator, 0);
    }

    @Override
    public long cost(MessageFrame frame, Supplier<Code> unused) {
        int inputOffset = Words.clampedToInt(frame.getStackItem(1));
        int inputSize = Words.clampedToInt(frame.getStackItem(2));
        return Words.clampedAdd(Words.clampedAdd(this.gasCalculator().txCreateCost(), this.gasCalculator().memoryExpansionGasCost(frame, inputOffset, inputSize)), Words.clampedAdd(this.gasCalculator().createKeccakCost(inputSize), this.gasCalculator().initcodeCost(inputSize)));
    }

    @Override
    public Address generateTargetContractAddress(MessageFrame frame, Code initcode) {
        Address sender = frame.getRecipientAddress();
        Bytes32 salt = Bytes32.leftPad((Bytes)frame.getStackItem(3));
        Bytes32 hash = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{PREFIX, sender, salt, initcode.getCodeHash()}));
        return Address.extract((Bytes32)hash);
    }

    @Override
    protected Code getInitCode(MessageFrame frame, EVM evm) {
        long inputOffset = Words.clampedToLong(frame.getStackItem(1));
        long inputSize = Words.clampedToLong(frame.getStackItem(2));
        Bytes inputData = frame.readMemory(inputOffset, inputSize);
        return evm.getCodeUncached(inputData);
    }
}

