/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.core;

import io.helidon.common.Weight;
import io.helidon.common.Weighted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;

public class WeightedBag<T>
implements Iterable<T> {
    private final Map<Double, List<T>> contents;
    private final double defaultWeight;

    private WeightedBag(Map<Double, List<T>> contents, double defaultWeight) {
        this.contents = contents;
        if (defaultWeight < 0.0) {
            throw new IllegalArgumentException("Weights must be greater or equal to 0");
        }
        this.defaultWeight = defaultWeight;
    }

    public static <T> WeightedBag<T> create() {
        return WeightedBag.create(100.0);
    }

    public static <T> WeightedBag<T> create(double defaultWeight) {
        return new WeightedBag<T>(new TreeMap<Double, List<T>>((o1, o2) -> Double.compare(o2, o1)), defaultWeight);
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public WeightedBag<T> readOnly() {
        return new WeightedBag<T>(Collections.unmodifiableMap(this.contents), this.defaultWeight);
    }

    public void merge(WeightedBag<? extends T> bag) {
        bag.contents.forEach((? super K weight, ? super V value) -> this.addAll((Iterable<? extends T>)value, (double)weight));
    }

    public WeightedBag<T> copyMe() {
        WeightedBag<T> copy = WeightedBag.create();
        copy.merge(this);
        return copy;
    }

    public void addAll(Iterable<? extends T> values) {
        for (T value : values) {
            this.add(value);
        }
    }

    public void addAll(Iterable<? extends T> values, double weight) {
        for (T value : values) {
            this.add(value, weight);
        }
    }

    public void add(T value) {
        double weight;
        Objects.requireNonNull(value);
        if (value instanceof Weighted) {
            Weighted weighted = (Weighted)value;
            weight = weighted.weight();
        } else {
            Weight annotation = value.getClass().getAnnotation(Weight.class);
            weight = annotation == null ? this.defaultWeight : annotation.value();
        }
        this.add(value, weight);
    }

    public void add(T value, double weight) {
        Objects.requireNonNull(value);
        if (weight < 0.0) {
            throw new IllegalArgumentException("Weights must be greater or equal to 0");
        }
        this.contents.compute(weight, (key, list) -> {
            ArrayList<Object> newList = list;
            if (newList == null) {
                newList = new ArrayList<Object>();
            }
            newList.add(value);
            return newList;
        });
    }

    public Stream<T> stream() {
        return this.contents.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream());
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }
}

