/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.RegistryMetrics;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceInstance;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Service.Contract
@Service.Describe
public interface ServiceRegistry {
    public static final TypeName TYPE = TypeName.create(ServiceRegistry.class);

    default public <T> T get(Class<T> contract) {
        return this.get(TypeName.create(contract));
    }

    default public <T> T getNamed(Class<T> contract, String name) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(name);
        return this.get(contract, Qualifier.createNamed(name));
    }

    default public <T> T get(Class<T> contract, Qualifier ... qualifiers) {
        Objects.requireNonNull(contract);
        Objects.requireNonNull(qualifiers);
        return this.get(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public <T> T get(TypeName var1);

    default public <T> T getNamed(TypeName contract, String name) {
        return this.get(contract, Qualifier.createNamed(name));
    }

    default public <T> T get(TypeName contract, Qualifier ... qualifiers) {
        return this.get(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    default public <T> Optional<T> first(Class<T> contract) {
        return this.first(TypeName.create(contract));
    }

    default public <T> Optional<T> firstNamed(Class<T> contract, String name) {
        return this.first(contract, Qualifier.createNamed(name));
    }

    default public <T> Optional<T> first(Class<T> contract, Qualifier ... qualifiers) {
        return this.first(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public <T> Optional<T> first(TypeName var1);

    default public <T> Optional<T> firstNamed(TypeName contract, String name) {
        return this.first(contract, Qualifier.createNamed(name));
    }

    default public <T> Optional<T> first(TypeName contract, Qualifier ... qualifiers) {
        return this.first(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    default public <T> List<T> all(Class<T> contract) {
        return this.all(TypeName.create(contract));
    }

    default public <T> List<T> all(Class<T> contract, Qualifier ... qualifiers) {
        return this.all(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public <T> List<T> all(TypeName var1);

    default public <T> List<T> all(TypeName contract, Qualifier ... qualifiers) {
        return this.all(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    default public <T> Supplier<T> supply(Class<T> contract) {
        return this.supply(TypeName.create(contract));
    }

    default public <T> Supplier<T> supply(Class<T> contract, Qualifier ... qualifiers) {
        return this.supply(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public <T> Supplier<T> supply(TypeName var1);

    default public <T> Supplier<T> supply(TypeName contract, Qualifier ... qualifiers) {
        return this.supply(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    default public <T> Supplier<Optional<T>> supplyFirst(Class<T> contract) {
        return this.supplyFirst(TypeName.create(contract));
    }

    default public <T> Supplier<Optional<T>> supplyFirst(Class<T> contract, Qualifier ... qualifiers) {
        return this.supplyFirst(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public <T> Supplier<Optional<T>> supplyFirst(TypeName var1);

    default public <T> Supplier<Optional<T>> supplyFirst(TypeName contract, Qualifier ... qualifiers) {
        return this.supplyFirst(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    default public <T> Supplier<List<T>> supplyAll(Class<T> contract) {
        return this.supplyAll(TypeName.create(contract));
    }

    default public <T> Supplier<List<T>> supplyAll(Class<T> contract, Qualifier ... qualifiers) {
        return this.supplyAll(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public <T> Supplier<List<T>> supplyAll(TypeName var1);

    default public <T> Supplier<List<T>> supplyAll(TypeName contract, Qualifier ... qualifiers) {
        return this.supplyAll(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(contract)).qualifiers(Set.of(qualifiers))).build());
    }

    public <T> Optional<T> get(ServiceInfo var1);

    default public List<ServiceInfo> allServices(Class<?> contract) {
        return this.allServices(TypeName.create(contract));
    }

    public List<ServiceInfo> allServices(TypeName var1);

    public <T> T get(Lookup var1);

    public <T> Optional<T> first(Lookup var1);

    public <T> List<T> all(Lookup var1);

    public <T> Supplier<T> supply(Lookup var1);

    public <T> Supplier<Optional<T>> supplyFirst(Lookup var1);

    public <T> Supplier<List<T>> supplyAll(Lookup var1);

    public List<ServiceInfo> lookupServices(Lookup var1);

    public <T> List<ServiceInstance<T>> lookupInstances(Lookup var1);

    public RegistryMetrics metrics();
}

