/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.RealmID;
import com.hedera.hapi.node.base.ShardID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.codec.FileCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.file.codec.FileCreateTransactionBodyProtoCodec;
import com.hedera.hapi.node.file.schema.FileCreateTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class FileCreateTransactionBody {
    public static final Codec<FileCreateTransactionBody> PROTOBUF = new FileCreateTransactionBodyProtoCodec();
    public static final JsonCodec<FileCreateTransactionBody> JSON = new FileCreateTransactionBodyJsonCodec();
    public static final FileCreateTransactionBody DEFAULT = FileCreateTransactionBody.newBuilder().build();
    @Nullable
    private final Timestamp expirationTime;
    @Nullable
    private final KeyList keys;
    @NonNull
    private final Bytes contents;
    @Nullable
    private final ShardID shardID;
    @Nullable
    private final RealmID realmID;
    @Nullable
    private final Key newRealmAdminKey;
    @NonNull
    private final String memo;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public FileCreateTransactionBody(Timestamp expirationTime, KeyList keys, Bytes contents, ShardID shardID, RealmID realmID, Key newRealmAdminKey, String memo) {
        this.$unknownFields = null;
        this.expirationTime = expirationTime;
        this.keys = keys;
        this.contents = contents != null ? contents : Bytes.EMPTY;
        this.shardID = shardID;
        this.realmID = realmID;
        this.newRealmAdminKey = newRealmAdminKey;
        this.memo = memo != null ? memo : "";
    }

    public FileCreateTransactionBody(Timestamp expirationTime, KeyList keys, Bytes contents, ShardID shardID, RealmID realmID, Key newRealmAdminKey, String memo, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.expirationTime = expirationTime;
        this.keys = keys;
        this.contents = contents != null ? contents : Bytes.EMPTY;
        this.shardID = shardID;
        this.realmID = realmID;
        this.newRealmAdminKey = newRealmAdminKey;
        this.memo = memo != null ? memo : "";
    }

    public Timestamp expirationTime() {
        return this.expirationTime;
    }

    public KeyList keys() {
        return this.keys;
    }

    public Bytes contents() {
        return this.contents;
    }

    public ShardID shardID() {
        return this.shardID;
    }

    public RealmID realmID() {
        return this.realmID;
    }

    public Key newRealmAdminKey() {
        return this.newRealmAdminKey;
    }

    public String memo() {
        return this.memo;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileCreateTransactionBodySchema.EXPIRATION_TIME, (Object)this.expirationTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileCreateTransactionBodySchema.KEYS, (Object)this.keys, KeyList.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)FileCreateTransactionBodySchema.CONTENTS, (RandomAccessData)this.contents, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileCreateTransactionBodySchema.SHARD_ID, (Object)this.shardID, ShardID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileCreateTransactionBodySchema.REALM_ID, (Object)this.realmID, RealmID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileCreateTransactionBodySchema.NEW_REALM_ADMIN_KEY, (Object)this.newRealmAdminKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)FileCreateTransactionBodySchema.MEMO, (String)this.memo, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.expirationTime != null && !this.expirationTime.equals(FileCreateTransactionBody.DEFAULT.expirationTime)) {
                result = 31 * result + this.expirationTime.hashCode();
            }
            if (this.keys != null && !this.keys.equals(FileCreateTransactionBody.DEFAULT.keys)) {
                result = 31 * result + this.keys.hashCode();
            }
            if (this.contents != null && !this.contents.equals((Object)FileCreateTransactionBody.DEFAULT.contents)) {
                result = 31 * result + this.contents.hashCode();
            }
            if (this.shardID != null && !this.shardID.equals(FileCreateTransactionBody.DEFAULT.shardID)) {
                result = 31 * result + this.shardID.hashCode();
            }
            if (this.realmID != null && !this.realmID.equals(FileCreateTransactionBody.DEFAULT.realmID)) {
                result = 31 * result + this.realmID.hashCode();
            }
            if (this.newRealmAdminKey != null && !this.newRealmAdminKey.equals(FileCreateTransactionBody.DEFAULT.newRealmAdminKey)) {
                result = 31 * result + this.newRealmAdminKey.hashCode();
            }
            if (this.memo != null && !this.memo.equals(FileCreateTransactionBody.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FileCreateTransactionBody thatObj = (FileCreateTransactionBody)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        if (this.keys == null && thatObj.keys != null) {
            return false;
        }
        if (this.keys != null && !this.keys.equals(thatObj.keys)) {
            return false;
        }
        if (this.contents == null && thatObj.contents != null) {
            return false;
        }
        if (this.contents != null && !this.contents.equals((Object)thatObj.contents)) {
            return false;
        }
        if (this.shardID == null && thatObj.shardID != null) {
            return false;
        }
        if (this.shardID != null && !this.shardID.equals(thatObj.shardID)) {
            return false;
        }
        if (this.realmID == null && thatObj.realmID != null) {
            return false;
        }
        if (this.realmID != null && !this.realmID.equals(thatObj.realmID)) {
            return false;
        }
        if (this.newRealmAdminKey == null && thatObj.newRealmAdminKey != null) {
            return false;
        }
        if (this.newRealmAdminKey != null && !this.newRealmAdminKey.equals(thatObj.newRealmAdminKey)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "FileCreateTransactionBody[expirationTime=" + String.valueOf(this.expirationTime) + ", keys=" + String.valueOf(this.keys) + ", contents=" + String.valueOf(this.contents) + ", shardID=" + String.valueOf(this.shardID) + ", realmID=" + String.valueOf(this.realmID) + ", newRealmAdminKey=" + String.valueOf(this.newRealmAdminKey) + ", memo=" + this.memo + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public boolean hasShardID() {
        return this.shardID != null;
    }

    public ShardID shardIDOrElse(@NonNull ShardID defaultValue) {
        return this.hasShardID() ? this.shardID : defaultValue;
    }

    @NonNull
    public ShardID shardIDOrThrow() {
        return Objects.requireNonNull(this.shardID, "Field shardID is null");
    }

    public void ifShardID(@NonNull Consumer<ShardID> ifPresent) {
        if (this.hasShardID()) {
            ifPresent.accept(this.shardID);
        }
    }

    public boolean hasRealmID() {
        return this.realmID != null;
    }

    public RealmID realmIDOrElse(@NonNull RealmID defaultValue) {
        return this.hasRealmID() ? this.realmID : defaultValue;
    }

    @NonNull
    public RealmID realmIDOrThrow() {
        return Objects.requireNonNull(this.realmID, "Field realmID is null");
    }

    public void ifRealmID(@NonNull Consumer<RealmID> ifPresent) {
        if (this.hasRealmID()) {
            ifPresent.accept(this.realmID);
        }
    }

    public boolean hasNewRealmAdminKey() {
        return this.newRealmAdminKey != null;
    }

    public Key newRealmAdminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasNewRealmAdminKey() ? this.newRealmAdminKey : defaultValue;
    }

    @NonNull
    public Key newRealmAdminKeyOrThrow() {
        return Objects.requireNonNull(this.newRealmAdminKey, "Field newRealmAdminKey is null");
    }

    public void ifNewRealmAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasNewRealmAdminKey()) {
            ifPresent.accept(this.newRealmAdminKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.expirationTime, this.keys, this.contents, this.shardID, this.realmID, this.newRealmAdminKey, this.memo, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Timestamp expirationTime = null;
        @Nullable
        private KeyList keys = null;
        @NonNull
        private Bytes contents = Bytes.EMPTY;
        @Nullable
        private ShardID shardID = null;
        @Nullable
        private RealmID realmID = null;
        @Nullable
        private Key newRealmAdminKey = null;
        @NonNull
        private String memo = "";
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(Timestamp expirationTime, KeyList keys, Bytes contents, ShardID shardID, RealmID realmID, Key newRealmAdminKey, String memo) {
            this.$unknownFields = null;
            this.expirationTime = expirationTime;
            this.keys = keys;
            this.contents = contents != null ? contents : Bytes.EMPTY;
            this.shardID = shardID;
            this.realmID = realmID;
            this.newRealmAdminKey = newRealmAdminKey;
            this.memo = memo != null ? memo : "";
        }

        public Builder(Timestamp expirationTime, KeyList keys, Bytes contents, ShardID shardID, RealmID realmID, Key newRealmAdminKey, String memo, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.expirationTime = expirationTime;
            this.keys = keys;
            this.contents = contents != null ? contents : Bytes.EMPTY;
            this.shardID = shardID;
            this.realmID = realmID;
            this.newRealmAdminKey = newRealmAdminKey;
            this.memo = memo != null ? memo : "";
        }

        public FileCreateTransactionBody build() {
            return new FileCreateTransactionBody(this.expirationTime, this.keys, this.contents, this.shardID, this.realmID, this.newRealmAdminKey, this.memo);
        }

        public Builder expirationTime(@Nullable Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder keys(@Nullable KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder contents(@NonNull Bytes contents) {
            this.contents = contents != null ? contents : Bytes.EMPTY;
            return this;
        }

        public Builder shardID(@Nullable ShardID shardID) {
            this.shardID = shardID;
            return this;
        }

        public Builder shardID(ShardID.Builder builder) {
            this.shardID = builder.build();
            return this;
        }

        public Builder realmID(@Nullable RealmID realmID) {
            this.realmID = realmID;
            return this;
        }

        public Builder realmID(RealmID.Builder builder) {
            this.realmID = builder.build();
            return this;
        }

        public Builder newRealmAdminKey(@Nullable Key newRealmAdminKey) {
            this.newRealmAdminKey = newRealmAdminKey;
            return this;
        }

        public Builder newRealmAdminKey(Key.Builder builder) {
            this.newRealmAdminKey = builder.build();
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Timestamp expirationTime() {
            return this.expirationTime;
        }

        public KeyList keys() {
            return this.keys;
        }

        public Bytes contents() {
            return this.contents;
        }

        public ShardID shardID() {
            return this.shardID;
        }

        public RealmID realmID() {
            return this.realmID;
        }

        public Key newRealmAdminKey() {
            return this.newRealmAdminKey;
        }

        public String memo() {
            return this.memo;
        }
    }
}

