/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees.congestion;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.congestion.ThrottleMultiplier;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableAirdropStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.throttle.annotations.CryptoTransferThrottleMultiplier;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.FeesConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.node.config.data.TopicsConfig;
import com.hedera.node.config.types.EntityScaleFactors;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UtilizationScaledThrottleMultiplier {
    private final ThrottleMultiplier delegate;
    private final ConfigProvider configProvider;

    @Inject
    public UtilizationScaledThrottleMultiplier(@CryptoTransferThrottleMultiplier @NonNull ThrottleMultiplier delegate, @NonNull ConfigProvider configProvider) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        this.configProvider = Objects.requireNonNull(configProvider, "configProvider must not be null");
    }

    public long currentMultiplier(@NonNull TransactionInfo txnInfo, @NonNull ReadableStoreFactory storeFactory) {
        return this.currentMultiplier(txnInfo.txBody(), txnInfo.functionality(), storeFactory);
    }

    public long currentMultiplier(@NonNull TransactionBody body, @NonNull HederaFunctionality functionality, @NonNull ReadableStoreFactory storeFactory) {
        long throttleMultiplier = this.delegate.currentMultiplier();
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        EntityScaleFactors entityScaleFactors = ((FeesConfig)configuration.getConfigData(FeesConfig.class)).percentUtilizationScaleFactors();
        return switch (functionality) {
            case HederaFunctionality.CRYPTO_CREATE -> entityScaleFactors.scaleForNew(EntityType.ACCOUNT, this.roundedAccountPercentUtil(storeFactory)).scaling((int)throttleMultiplier);
            case HederaFunctionality.CONTRACT_CREATE -> entityScaleFactors.scaleForNew(EntityType.CONTRACT_BYTECODE, this.roundedContractPercentUtil(storeFactory)).scaling((int)throttleMultiplier);
            case HederaFunctionality.FILE_CREATE -> entityScaleFactors.scaleForNew(EntityType.FILE, this.roundedFilePercentUtil(storeFactory)).scaling((int)throttleMultiplier);
            case HederaFunctionality.TOKEN_MINT -> {
                boolean mintsWithMetadata;
                boolean v1 = mintsWithMetadata = !body.tokenMintOrThrow().metadata().isEmpty();
                if (mintsWithMetadata) {
                    yield entityScaleFactors.scaleForNew(EntityType.NFT, this.roundedNftPercentUtil(storeFactory)).scaling((int)throttleMultiplier);
                }
                yield throttleMultiplier;
            }
            case HederaFunctionality.TOKEN_CREATE -> entityScaleFactors.scaleForNew(EntityType.TOKEN, this.roundedTokenPercentUtil(storeFactory)).scaling((int)throttleMultiplier);
            case HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT -> entityScaleFactors.scaleForNew(EntityType.TOKEN_ASSOCIATION, this.roundedTokenRelPercentUtil(storeFactory)).scaling((int)throttleMultiplier);
            case HederaFunctionality.CONSENSUS_CREATE_TOPIC -> entityScaleFactors.scaleForNew(EntityType.TOPIC, this.roundedTopicPercentUtil(storeFactory)).scaling((int)throttleMultiplier);
            case HederaFunctionality.TOKEN_AIRDROP -> entityScaleFactors.scaleForNew(EntityType.AIRDROP, this.roundedAirdropPercentUtil(storeFactory)).scaling((int)throttleMultiplier);
            default -> throttleMultiplier;
        };
    }

    private int roundedAccountPercentUtil(@NonNull ReadableStoreFactory storeFactory) {
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        long maxNumOfAccounts = ((AccountsConfig)configuration.getConfigData(AccountsConfig.class)).maxNumber();
        ReadableAccountStore accountsStore = storeFactory.getStore(ReadableAccountStore.class);
        long numAccountsAndContracts = accountsStore.sizeOfAccountState();
        ContractStateStore contractsStore = storeFactory.getStore(ContractStateStore.class);
        long numContracts = contractsStore.getNumBytecodes();
        long numAccounts = numAccountsAndContracts - numContracts;
        return maxNumOfAccounts == 0L ? 100 : (int)(100L * numAccounts / maxNumOfAccounts);
    }

    private int roundedContractPercentUtil(@NonNull ReadableStoreFactory storeFactory) {
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        long maxNumOfContracts = ((ContractsConfig)configuration.getConfigData(ContractsConfig.class)).maxNumber();
        ContractStateStore contractsStore = storeFactory.getStore(ContractStateStore.class);
        long numContracts = contractsStore.getNumBytecodes();
        return maxNumOfContracts == 0L ? 100 : (int)(100L * numContracts / maxNumOfContracts);
    }

    private int roundedFilePercentUtil(@NonNull ReadableStoreFactory storeFactory) {
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        long maxNumOfFiles = ((FilesConfig)configuration.getConfigData(FilesConfig.class)).maxNumber();
        ReadableFileStore fileStore = storeFactory.getStore(ReadableFileStore.class);
        long numOfFiles = fileStore.sizeOfState();
        return maxNumOfFiles == 0L ? 100 : (int)(100L * numOfFiles / maxNumOfFiles);
    }

    private int roundedNftPercentUtil(@NonNull ReadableStoreFactory storeFactory) {
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        long maxNumOfNfts = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).nftsMaxAllowedMints();
        ReadableNftStore nftStore = storeFactory.getStore(ReadableNftStore.class);
        long numOfNfts = nftStore.sizeOfState();
        return maxNumOfNfts == 0L ? 100 : (int)(100L * numOfNfts / maxNumOfNfts);
    }

    private int roundedTokenPercentUtil(@NonNull ReadableStoreFactory storeFactory) {
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        long maxNumOfTokens = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).maxNumber();
        ReadableTokenStore tokenStore = storeFactory.getStore(ReadableTokenStore.class);
        long numOfTokens = tokenStore.sizeOfState();
        return maxNumOfTokens == 0L ? 100 : (int)(100L * numOfTokens / maxNumOfTokens);
    }

    private int roundedTokenRelPercentUtil(@NonNull ReadableStoreFactory storeFactory) {
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        long maxNumOfTokenRels = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).maxAggregateRels();
        ReadableTokenRelationStore tokenRelStore = storeFactory.getStore(ReadableTokenRelationStore.class);
        long numOfTokensRels = tokenRelStore.sizeOfState();
        return maxNumOfTokenRels == 0L ? 100 : (int)(100L * numOfTokensRels / maxNumOfTokenRels);
    }

    private int roundedTopicPercentUtil(@NonNull ReadableStoreFactory storeFactory) {
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        long maxNumberOfTopics = ((TopicsConfig)configuration.getConfigData(TopicsConfig.class)).maxNumber();
        ReadableTopicStore topicStore = storeFactory.getStore(ReadableTopicStore.class);
        long numOfTopics = topicStore.sizeOfState();
        return maxNumberOfTopics == 0L ? 100 : (int)(100L * numOfTopics / maxNumberOfTopics);
    }

    private int roundedAirdropPercentUtil(@NonNull ReadableStoreFactory storeFactory) {
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        long maxNumAirdrops = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).maxAllowedPendingAirdrops();
        ReadableAirdropStore airdropStore = storeFactory.getStore(ReadableAirdropStore.class);
        long numPendingAirdrops = airdropStore.sizeOfState();
        return maxNumAirdrops == 0L ? 100 : (int)(100L * numPendingAirdrops / maxNumAirdrops);
    }

    public void updateMultiplier(@NonNull Instant consensusTime) {
        this.delegate.updateMultiplier(consensusTime);
    }

    public void resetExpectations() {
        this.delegate.resetExpectations();
    }

    public void resetCongestionLevelStarts(@NonNull Instant[] startTimes) {
        this.delegate.resetCongestionLevelStarts(startTimes);
    }

    @NonNull
    public Instant[] congestionLevelStarts() {
        return this.delegate.congestionLevelStarts();
    }
}

