/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.signature;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.node.app.hapi.utils.keys.KeyComparator;
import com.hedera.node.app.signature.AppKeyVerifier;
import com.hedera.node.app.signature.CompoundSignatureVerificationFuture;
import com.hedera.node.app.signature.SignatureVerificationFuture;
import com.hedera.node.app.signature.impl.SignatureVerificationImpl;
import com.hedera.node.app.spi.signatures.SignatureVerification;
import com.hedera.node.app.spi.signatures.VerificationAssistant;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultKeyVerifier
implements AppKeyVerifier {
    private static final Logger logger = LogManager.getLogger(DefaultKeyVerifier.class);
    private static final Comparator<Key> KEY_COMPARATOR = new KeyComparator();
    private final long timeout;
    private final Map<Key, SignatureVerificationFuture> keyVerifications;

    public DefaultKeyVerifier(@NonNull HederaConfig config, @NonNull Map<Key, SignatureVerificationFuture> keyVerifications) {
        this.timeout = Objects.requireNonNull(config, "config must not be null").workflowVerificationTimeoutMS();
        this.keyVerifications = Objects.requireNonNull(keyVerifications, "keyVerifications must not be null");
    }

    @NonNull
    public SignatureVerification verificationFor(@NonNull Key key) {
        Objects.requireNonNull(key, "key must not be null");
        return this.resolveFuture(this.verificationFutureFor(key), () -> SignatureVerificationImpl.failedVerification(key));
    }

    @NonNull
    public SignatureVerification verificationFor(@NonNull Key key, @NonNull VerificationAssistant callback) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(callback, "callback must not be null");
        return switch ((Key.KeyOneOfType)key.key().kind()) {
            default -> throw new MatchException(null, null);
            case Key.KeyOneOfType.ED25519, Key.KeyOneOfType.ECDSA_SECP256K1 -> {
                SignatureVerification result = this.resolveFuture(this.keyVerifications.get(key), () -> SignatureVerificationImpl.failedVerification(key));
                if (callback.test((Object)key, (Object)result)) {
                    yield SignatureVerificationImpl.passedVerification(key);
                }
                yield SignatureVerificationImpl.failedVerification(key);
            }
            case Key.KeyOneOfType.KEY_LIST -> {
                List keys = key.keyListOrThrow().keys();
                boolean failed = keys.isEmpty();
                for (Key childKey : keys) {
                    failed |= this.verificationFor(childKey, callback).failed();
                }
                if (failed) {
                    yield SignatureVerificationImpl.failedVerification(key);
                }
                yield SignatureVerificationImpl.passedVerification(key);
            }
            case Key.KeyOneOfType.THRESHOLD_KEY -> {
                ThresholdKey thresholdKey = key.thresholdKeyOrThrow();
                KeyList keyList = thresholdKey.keysOrElse(KeyList.DEFAULT);
                List keys = keyList.keys();
                int threshold = thresholdKey.threshold();
                int clampedThreshold = Math.max(1, Math.min(threshold, keys.size()));
                int passed = 0;
                for (Key childKey : keys) {
                    if (!this.verificationFor(childKey, callback).passed()) continue;
                    ++passed;
                }
                if (passed >= clampedThreshold) {
                    yield SignatureVerificationImpl.passedVerification(key);
                }
                yield SignatureVerificationImpl.failedVerification(key);
            }
            case Key.KeyOneOfType.CONTRACT_ID, Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID, Key.KeyOneOfType.ECDSA_384, Key.KeyOneOfType.RSA_3072, Key.KeyOneOfType.UNSET -> {
                SignatureVerification failure = SignatureVerificationImpl.failedVerification(key);
                if (callback.test((Object)key, (Object)failure)) {
                    yield SignatureVerificationImpl.passedVerification(key);
                }
                yield failure;
            }
        };
    }

    @Override
    @NonNull
    public SignatureVerification verificationFor(@NonNull Bytes evmAlias) {
        Objects.requireNonNull(evmAlias, "evmAlias must not be null");
        if (evmAlias.length() == 20L) {
            for (SignatureVerificationFuture result : this.keyVerifications.values()) {
                Bytes account = result.evmAlias();
                if (account == null || !evmAlias.matchesPrefix((RandomAccessData)account)) continue;
                return this.resolveFuture(result, () -> SignatureVerificationImpl.failedVerification(evmAlias));
            }
        }
        return SignatureVerificationImpl.failedVerification(evmAlias);
    }

    @Override
    public int numSignaturesVerified() {
        return this.keyVerifications.size();
    }

    public SortedSet<Key> authorizingSimpleKeys() {
        return this.keyVerifications.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<Key, SignatureVerification>((Key)entry.getKey(), this.resolveFuture((Future)entry.getValue(), () -> SignatureVerificationImpl.failedVerification((Key)entry.getKey())))).filter(e -> ((SignatureVerification)e.getValue()).passed()).map(Map.Entry::getKey).collect(Collectors.toCollection(() -> new TreeSet<Key>(KEY_COMPARATOR)));
    }

    @NonNull
    private Future<SignatureVerification> verificationFutureFor(@NonNull Key key) {
        return switch ((Key.KeyOneOfType)key.key().kind()) {
            default -> throw new MatchException(null, null);
            case Key.KeyOneOfType.ED25519, Key.KeyOneOfType.ECDSA_SECP256K1 -> {
                SignatureVerificationFuture result = this.keyVerifications.get(key);
                if (result == null) {
                    yield CompletableFuture.completedFuture(SignatureVerificationImpl.failedVerification(key));
                }
                yield result;
            }
            case Key.KeyOneOfType.KEY_LIST -> {
                List keys = key.keyListOrThrow().keys();
                yield this.verificationFutureFor(key, keys, 0);
            }
            case Key.KeyOneOfType.THRESHOLD_KEY -> {
                ThresholdKey thresholdKey = key.thresholdKeyOrThrow();
                KeyList keyList = thresholdKey.keysOrElse(KeyList.DEFAULT);
                List keys = keyList.keys();
                int threshold = thresholdKey.threshold();
                int clampedThreshold = Math.max(1, Math.min(threshold, keys.size()));
                yield this.verificationFutureFor(key, keys, keys.size() - clampedThreshold);
            }
            case Key.KeyOneOfType.CONTRACT_ID, Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID, Key.KeyOneOfType.ECDSA_384, Key.KeyOneOfType.RSA_3072, Key.KeyOneOfType.UNSET -> CompletableFuture.completedFuture(SignatureVerificationImpl.failedVerification(key));
        };
    }

    @NonNull
    private Future<SignatureVerification> verificationFutureFor(@NonNull Key key, @NonNull List<Key> keys, int numCanFail) {
        if (keys.isEmpty() || numCanFail < 0) {
            return CompletableFuture.completedFuture(SignatureVerificationImpl.failedVerification(key));
        }
        List<Future<SignatureVerification>> futures = keys.stream().map(this::verificationFutureFor).toList();
        return new CompoundSignatureVerificationFuture(key, null, futures, numCanFail);
    }

    @NonNull
    private SignatureVerification resolveFuture(@Nullable Future<SignatureVerification> future, @NonNull Supplier<SignatureVerification> fallback) {
        if (future == null) {
            return fallback.get();
        }
        try {
            return future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Interrupted while waiting for signature verification", (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.warn("Timed out while waiting for signature verification, probably going to ISS soon", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error("An unexpected exception was thrown while waiting for SignatureVerification", (Throwable)e);
        }
        return fallback.get();
    }
}

