/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.ingest;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.node.app.quiescence.TxPipelineTracker;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.InsufficientBalanceException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.throttle.ThrottleUsage;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.ingest.IngestChecker;
import com.hedera.node.app.workflows.ingest.IngestWorkflow;
import com.hedera.node.app.workflows.ingest.SubmissionManager;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.QuiescenceConfig;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public final class IngestWorkflowImpl
implements IngestWorkflow {
    private static final Logger logger = LogManager.getLogger(IngestWorkflowImpl.class);
    private final Supplier<AutoCloseableWrapper<State>> stateAccessor;
    private final IngestChecker ingestChecker;
    private final SubmissionManager submissionManager;
    private final TxPipelineTracker txPipelineTracker;
    private final ConfigProvider configProvider;
    private final boolean quiescenceEnabled;

    @Inject
    public IngestWorkflowImpl(@NonNull Supplier<AutoCloseableWrapper<State>> stateAccessor, @NonNull IngestChecker ingestChecker, @NonNull SubmissionManager submissionManager, @NonNull TxPipelineTracker txPipelineTracker, @NonNull ConfigProvider configProvider) {
        this.stateAccessor = Objects.requireNonNull(stateAccessor);
        this.ingestChecker = Objects.requireNonNull(ingestChecker);
        this.submissionManager = Objects.requireNonNull(submissionManager);
        this.txPipelineTracker = Objects.requireNonNull(txPipelineTracker);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.quiescenceEnabled = ((QuiescenceConfig)configProvider.getConfiguration().getConfigData(QuiescenceConfig.class)).enabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitTransaction(@NonNull Bytes requestBuffer, @NonNull BufferedData responseBuffer) {
        Objects.requireNonNull(requestBuffer);
        Objects.requireNonNull(responseBuffer);
        try {
            if (this.quiescenceEnabled) {
                this.txPipelineTracker.incrementPreFlight();
            }
            ResponseCodeEnum result = ResponseCodeEnum.OK;
            long estimatedFee = 0L;
            IngestChecker.Result checkerResult = new IngestChecker.Result();
            try (AutoCloseableWrapper<State> wrappedState = this.stateAccessor.get();){
                this.ingestChecker.verifyReadyForTransactions();
                State state = (State)wrappedState.get();
                VersionedConfiguration configuration = this.configProvider.getConfiguration();
                this.ingestChecker.runAllChecks(state, requestBuffer, (Configuration)configuration, checkerResult);
                TransactionInfo txInfo = checkerResult.txnInfoOrThrow();
                this.submissionManager.submit(txInfo.txBody(), txInfo.serializedSignedTxOrThrow());
                if (this.quiescenceEnabled) {
                    this.txPipelineTracker.incrementInFlight();
                }
            }
            catch (InsufficientBalanceException e) {
                estimatedFee = e.getEstimatedFee();
                result = e.responseCode();
            }
            catch (PreCheckException e) {
                logger.debug("Transaction failed pre-check", (Throwable)e);
                result = e.responseCode();
            }
            catch (HandleException e) {
                logger.debug("Transaction failed pre-check", (Throwable)e);
                result = e.getStatus();
            }
            catch (Exception e) {
                logger.error("Possibly CATASTROPHIC failure while running the ingest workflow", (Throwable)e);
                result = ResponseCodeEnum.FAIL_INVALID;
            }
            if (result != ResponseCodeEnum.OK) {
                checkerResult.throttleUsages().forEach(ThrottleUsage::reclaimCapacity);
            }
            TransactionResponse transactionResponse = TransactionResponse.newBuilder().nodeTransactionPrecheckCode(result).cost(estimatedFee).build();
            try {
                TransactionResponse.PROTOBUF.write((Object)transactionResponse, (WritableSequentialData)responseBuffer);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to write bytes to response buffer", ex);
            }
        }
        finally {
            if (this.quiescenceEnabled) {
                this.txPipelineTracker.decrementPreFlight();
            }
        }
    }
}

