/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.prehandle;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.workflows.InnerTransaction;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.hedera.node.app.workflows.prehandle.PreHandleWorkflowImpl;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public interface PreHandleWorkflow {
    public static final Logger log = LogManager.getLogger(PreHandleWorkflow.class);

    public void preHandle(@NonNull ReadableStoreFactory var1, @Nullable NodeInfo var2, @NonNull Stream<Transaction> var3, @NonNull BiConsumer<StateSignatureTransaction, Bytes> var4);

    @NonNull
    public PreHandleResult preHandleTransaction(@Nullable NodeInfo var1, @NonNull ReadableStoreFactory var2, @NonNull ReadableAccountStore var3, @NonNull Bytes var4, @Nullable PreHandleResult var5, @NonNull BiConsumer<StateSignatureTransaction, Bytes> var6, @NonNull InnerTransaction var7);

    default public PreHandleResult preHandleAllTransactions(@Nullable NodeInfo creatorInfo, @NonNull ReadableStoreFactory storeFactory, @NonNull ReadableAccountStore accountStore, @NonNull Bytes serializedSignedTx, @Nullable PreHandleResult maybeReusableResult, @NonNull BiConsumer<StateSignatureTransaction, Bytes> shortCircuitTxnCallback) {
        PreHandleResult result = this.preHandleTransaction(creatorInfo, storeFactory, accountStore, serializedSignedTx, maybeReusableResult, shortCircuitTxnCallback, InnerTransaction.NO);
        if (result.txInfo() != null && PreHandleWorkflowImpl.isAtomicBatch(result.txInfo()) && result.status() == PreHandleResult.Status.SO_FAR_SO_GOOD) {
            boolean useInnerResults;
            List innerTxns = result.txInfo().txBody().atomicBatchOrThrow().transactions();
            boolean bl = useInnerResults = maybeReusableResult != null && maybeReusableResult.innerResults() != null && !maybeReusableResult.innerResults().isEmpty();
            if (useInnerResults && maybeReusableResult.innerResults().size() != innerTxns.size()) {
                useInnerResults = false;
                log.warn("The number of inner results in the atomic batch transaction does not match the number of inner transactions. Need to re-run pre-handle for all inner transactions.");
            }
            for (int i = 0; i < innerTxns.size(); ++i) {
                PreHandleResult innerResult = this.preHandleTransaction(creatorInfo, storeFactory, accountStore, (Bytes)innerTxns.get(i), useInnerResults ? maybeReusableResult.innerResults().get(i) : null, (ignore, ignored) -> {}, InnerTransaction.YES);
                if (result.innerResults() == null) continue;
                result.innerResults().add(innerResult);
            }
        }
        return result;
    }

    @NonNull
    default public PreHandleResult getCurrentPreHandleResult(@Nullable NodeInfo creator, @NonNull ConsensusTransaction platformTxn, @NonNull ReadableStoreFactory storeFactory, @NonNull BiConsumer<StateSignatureTransaction, Bytes> shortCircuitTxnCallback) {
        PreHandleResult previousResult;
        Object metadata = platformTxn.getMetadata();
        if (metadata == null) {
            previousResult = PreHandleResult.shortCircuitingTransaction(null);
        } else if (metadata instanceof PreHandleResult) {
            PreHandleResult result;
            previousResult = result = (PreHandleResult)metadata;
        } else {
            log.error("Received transaction without PreHandleResult metadata from node {} (was {})", (Object)(creator != null ? Long.valueOf(creator.nodeId()) : null), metadata);
            previousResult = null;
        }
        return this.preHandleAllTransactions(creator, storeFactory, storeFactory.getStore(ReadableAccountStore.class), platformTxn.getApplicationTransaction(), previousResult, shortCircuitTxnCallback);
    }
}

