/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.fee;

import com.hedera.node.app.hapi.utils.builder.RequestBuilder;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hederahashgraph.api.proto.java.AccountID;
import com.hederahashgraph.api.proto.java.ConsensusCreateTopicTransactionBody;
import com.hederahashgraph.api.proto.java.ConsensusUpdateTopicTransactionBody;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.FixedCustomFee;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.api.proto.java.TransactionBody;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public final class ConsensusServiceFeeBuilder
extends FeeBuilder {
    private static final int FIXED_HBAR_REPR_SIZE = 8;
    private static final int FIXED_HTS_REPR_SIZE = 32;

    private ConsensusServiceFeeBuilder() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static FeeData getConsensusCreateTopicFee(TransactionBody txBody, SigValueObj sigValObj) {
        ConsensusCreateTopicTransactionBody createTopicTxBody = txBody.getConsensusCreateTopic();
        int variableSize = ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage(createTopicTxBody.getAdminKey(), createTopicTxBody.getSubmitKey(), createTopicTxBody.getMemo(), createTopicTxBody.hasAutoRenewAccount());
        long extraRbsServices = 0L;
        if (createTopicTxBody.hasAutoRenewPeriod()) {
            extraRbsServices = (long)ConsensusServiceFeeBuilder.getTopicRamBytes(variableSize + ConsensusServiceFeeBuilder.bytesNeededToRepr(createTopicTxBody.getCustomFeesList())) * createTopicTxBody.getAutoRenewPeriod().getSeconds();
        }
        return ConsensusServiceFeeBuilder.getTxFeeMatrices(txBody, sigValObj, variableSize + 8, extraRbsServices, 4320L);
    }

    public static FeeData getConsensusUpdateTopicFee(TransactionBody txBody, long rbsIncrease, SigValueObj sigValObj) {
        ConsensusUpdateTopicTransactionBody updateTopicTxBody = txBody.getConsensusUpdateTopic();
        int variableSize = ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage(updateTopicTxBody.getAdminKey(), updateTopicTxBody.getSubmitKey(), updateTopicTxBody.getMemo().getValue(), updateTopicTxBody.hasAutoRenewAccount());
        return ConsensusServiceFeeBuilder.getTxFeeMatrices(txBody, sigValObj, ConsensusServiceFeeBuilder.getConsensusUpdateTopicTransactionBodySize(updateTopicTxBody, variableSize), rbsIncrease, 0L);
    }

    private static int getConsensusUpdateTopicTransactionBodySize(ConsensusUpdateTopicTransactionBody updateTopicTxBody, int variableSize) {
        int calcSize = 24 + variableSize;
        if (updateTopicTxBody.hasExpirationTime()) {
            calcSize += 8;
        }
        if (updateTopicTxBody.hasAutoRenewPeriod()) {
            calcSize += 8;
        }
        return calcSize;
    }

    public static long getUpdateTopicRbsIncrease(Timestamp txValidStartTimestamp, Key oldAdminKey, Key oldSubmitKey, String oldMemo, boolean hasOldAutoRenewAccount, Timestamp oldExpirationTimeStamp, ConsensusUpdateTopicTransactionBody updateTopicTxBody) {
        int oldRamBytes = ConsensusServiceFeeBuilder.getTopicRamBytes(ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage(oldAdminKey, oldSubmitKey, oldMemo, hasOldAutoRenewAccount));
        String newMemo = updateTopicTxBody.hasMemo() ? updateTopicTxBody.getMemo().getValue() : oldMemo;
        boolean hasNewAutoRenewAccount = hasOldAutoRenewAccount;
        if (updateTopicTxBody.hasAutoRenewAccount()) {
            hasNewAutoRenewAccount = true;
            AccountID account = updateTopicTxBody.getAutoRenewAccount();
            if (account.getAccountNum() == 0L && account.getShardNum() == 0L && account.getRealmNum() == 0L) {
                hasNewAutoRenewAccount = false;
            }
        }
        Key newAdminKey = oldAdminKey;
        if (updateTopicTxBody.hasAdminKey() && (newAdminKey = updateTopicTxBody.getAdminKey()).hasKeyList() && newAdminKey.getKeyList().getKeysCount() == 0) {
            newAdminKey = null;
        }
        Key newSubmitKey = oldSubmitKey;
        if (updateTopicTxBody.hasSubmitKey() && (newSubmitKey = updateTopicTxBody.getSubmitKey()).hasKeyList() && newSubmitKey.getKeyList().getKeysCount() == 0) {
            newSubmitKey = null;
        }
        int newRamBytes = ConsensusServiceFeeBuilder.getTopicRamBytes(ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage(newAdminKey, newSubmitKey, newMemo, hasNewAutoRenewAccount));
        Timestamp newExpirationTimeStamp = updateTopicTxBody.hasExpirationTime() ? updateTopicTxBody.getExpirationTime() : oldExpirationTimeStamp;
        return ConsensusServiceFeeBuilder.calculateRbsIncrease(txValidStartTimestamp, oldRamBytes, oldExpirationTimeStamp, newRamBytes, newExpirationTimeStamp);
    }

    private static long calculateRbsIncrease(Timestamp txValidStartTimestamp, long oldRamBytes, Timestamp oldExpirationTimeStamp, long newRamBytes, Timestamp newExpirationTimeStamp) {
        long rbsRefund;
        Instant txValidStart = RequestBuilder.convertProtoTimeStamp(txValidStartTimestamp);
        Instant oldExpiration = RequestBuilder.convertProtoTimeStamp(oldExpirationTimeStamp);
        Instant newExpiration = RequestBuilder.convertProtoTimeStamp(newExpirationTimeStamp);
        long oldLifetime = Math.min(3153600000L, Duration.between(txValidStart, oldExpiration).getSeconds());
        long newLifetime = Math.min(3153600000L, Duration.between(txValidStart, newExpiration).getSeconds());
        long rbsCharge = newRamBytes * newLifetime;
        long netRbs = rbsCharge - (rbsRefund = oldRamBytes * oldLifetime);
        return netRbs > 0L ? netRbs : 0L;
    }

    public static FeeData getConsensusDeleteTopicFee(TransactionBody txBody, SigValueObj sigValObj) {
        return ConsensusServiceFeeBuilder.getTxFeeMatrices(txBody, sigValObj, 24, 0L, 0L);
    }

    private static FeeData getTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj, int txBodyDataSize, long extraRbsServices, long extraRbsNetwork) {
        FeeComponents.Builder feeComponentsBuilder = FeeComponents.newBuilder().setVpt((long)sigValObj.getTotalSigCount()).setSbh(0L).setGas(0L).setTv(0L).setBpr(4L).setSbpr(0L);
        feeComponentsBuilder.setBpt(ConsensusServiceFeeBuilder.getCommonTransactionBodyBytes(txBody) + (long)txBodyDataSize + (long)sigValObj.getSignatureSize());
        feeComponentsBuilder.setRbh((long)ConsensusServiceFeeBuilder.getBaseTransactionRecordSize(txBody) * 180L + extraRbsServices);
        long rbsNetwork = ConsensusServiceFeeBuilder.getDefaultRbhNetworkSize() + extraRbsNetwork;
        return ConsensusServiceFeeBuilder.getFeeDataMatrices(feeComponentsBuilder.build(), sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public static int getTopicRamBytes(int variableSize) {
        return 100 + variableSize;
    }

    public static int computeVariableSizedFieldsUsage(Key adminKey, Key submitKey, String memo, boolean hasAutoRenewAccount) {
        int size = 0;
        if (memo != null) {
            size += memo.getBytes(StandardCharsets.UTF_8).length;
        }
        size += ConsensusServiceFeeBuilder.getAccountKeyStorageSize(adminKey);
        size += ConsensusServiceFeeBuilder.getAccountKeyStorageSize(submitKey);
        return size += hasAutoRenewAccount ? 24 : 0;
    }

    public static int bytesNeededToRepr(List<FixedCustomFee> feeSchedule) {
        int numFixedHbarFees = 0;
        int numFixedHtsFees = 0;
        for (FixedCustomFee fee : feeSchedule) {
            if (!fee.hasFixedFee()) continue;
            if (fee.getFixedFee().hasDenominatingTokenId()) {
                ++numFixedHtsFees;
                continue;
            }
            ++numFixedHbarFees;
        }
        return ConsensusServiceFeeBuilder.bytesNeededToRepr(numFixedHbarFees, numFixedHtsFees);
    }

    public static int bytesNeededToRepr(int numFixedHbarFees, int numFixedHtsFees) {
        return numFixedHbarFees * ConsensusServiceFeeBuilder.plusCollectorSize(8) + numFixedHtsFees * ConsensusServiceFeeBuilder.plusCollectorSize(32);
    }

    private static int plusCollectorSize(int feeReprSize) {
        return feeReprSize + 24;
    }
}

