/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoAllowance;
import com.hedera.hapi.node.token.CryptoApproveAllowanceTransactionBody;
import com.hedera.hapi.node.token.NftAllowance;
import com.hedera.hapi.node.token.TokenAllowance;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.AllowanceValidator;
import com.hedera.node.app.service.token.impl.validators.ApproveAllowanceValidator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.HederaConfig;
import com.swirlds.base.utility.Pair;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoApproveAllowanceHandler
implements TransactionHandler {
    private final ApproveAllowanceValidator allowanceValidator;

    @Inject
    public CryptoApproveAllowanceHandler(@NonNull ApproveAllowanceValidator allowanceValidator) {
        this.allowanceValidator = allowanceValidator;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        CryptoApproveAllowanceTransactionBody op = txn.cryptoApproveAllowanceOrThrow();
        List cryptoAllowances = op.cryptoAllowances();
        List tokenAllowances = op.tokenAllowances();
        List nftAllowances = op.nftAllowances();
        int totalAllowancesSize = cryptoAllowances.size() + tokenAllowances.size() + nftAllowances.size();
        PreCheckException.validateTruePreCheck((totalAllowancesSize != 0 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EMPTY_ALLOWANCES);
        for (CryptoAllowance allowance : cryptoAllowances) {
            Validations.validateNullableAccountID((AccountID)allowance.owner());
            PreCheckException.validateTruePreCheck((allowance.amount() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NEGATIVE_ALLOWANCE_AMOUNT);
            Validations.validateAccountID((AccountID)allowance.spender(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID);
        }
        for (CryptoAllowance allowance : tokenAllowances) {
            Validations.validateNullableAccountID((AccountID)allowance.owner());
            PreCheckException.validateTruePreCheck((allowance.amount() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NEGATIVE_ALLOWANCE_AMOUNT);
            Validations.validateAccountID((AccountID)allowance.spender(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID);
            Validations.mustExist((Object)allowance.tokenId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        for (CryptoAllowance allowance : nftAllowances) {
            Validations.validateNullableAccountID((AccountID)allowance.owner());
            Validations.validateAccountID((AccountID)allowance.spender(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID);
            Validations.mustExist((Object)allowance.tokenId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        AccountID owner;
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        AccountID payerId = context.payer();
        CryptoApproveAllowanceTransactionBody op = txn.cryptoApproveAllowanceOrThrow();
        for (CryptoAllowance allowance : op.cryptoAllowances()) {
            owner = allowance.owner();
            if (owner == null || owner.equals((Object)payerId)) continue;
            context.requireKeyOrThrow(owner, ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID);
        }
        for (CryptoAllowance allowance : op.tokenAllowances()) {
            owner = allowance.owner();
            if (owner != null && owner.hasAlias()) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID);
            }
            if (owner == null || owner.equals((Object)payerId)) continue;
            context.requireKeyOrThrow(owner, ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID);
        }
        for (CryptoAllowance allowance : op.nftAllowances()) {
            AccountID ownerId = allowance.owner();
            boolean approvedForAll = allowance.approvedForAllOrElse(Boolean.valueOf(false));
            AccountID operatorId = approvedForAll ? ownerId : allowance.delegatingSpenderOrElse(ownerId);
            if (operatorId == null || operatorId.equals((Object)payerId)) continue;
            ResponseCodeEnum error = ownerId == operatorId ? ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID : ResponseCodeEnum.INVALID_DELEGATING_SPENDER;
            context.requireKeyOrThrow(operatorId, error);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        AccountID payer = context.payer();
        WritableAccountStore accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        Account payerAccount = TokenHandlerHelper.getIfUsable(payer, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_PAYER_ACCOUNT_ID);
        this.validateSemantics(context, payerAccount, accountStore);
        this.approveAllowance(context, payer, accountStore);
    }

    private void validateSemantics(@NonNull HandleContext context, @NonNull Account payerAccount, @NonNull ReadableAccountStore accountStore) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(payerAccount);
        Objects.requireNonNull(accountStore);
        this.allowanceValidator.validate(context, payerAccount, accountStore);
    }

    private void approveAllowance(@NonNull HandleContext context, @NonNull AccountID payerId, @NonNull WritableAccountStore accountStore) throws HandleException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(accountStore);
        CryptoApproveAllowanceTransactionBody op = context.body().cryptoApproveAllowanceOrThrow();
        List cryptoAllowances = op.cryptoAllowances();
        List tokenAllowances = op.tokenAllowances();
        List nftAllowances = op.nftAllowances();
        HederaConfig hederaConfig = (HederaConfig)context.configuration().getConfigData(HederaConfig.class);
        StoreFactory storeFactory = context.storeFactory();
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableNftStore uniqueTokenStore = (WritableNftStore)storeFactory.writableStore(WritableNftStore.class);
        int allowanceMaxAccountLimit = hederaConfig.allowancesMaxAccountLimit();
        ExpiryValidator expiryValidator = context.expiryValidator();
        this.applyCryptoAllowances(cryptoAllowances, payerId, accountStore, allowanceMaxAccountLimit, expiryValidator);
        this.applyFungibleTokenAllowances(tokenAllowances, payerId, accountStore, allowanceMaxAccountLimit, expiryValidator);
        this.applyNftAllowances(nftAllowances, payerId, accountStore, tokenStore, uniqueTokenStore, allowanceMaxAccountLimit, expiryValidator);
    }

    private void applyCryptoAllowances(@NonNull List<CryptoAllowance> cryptoAllowances, @NonNull AccountID payerId, @NonNull WritableAccountStore accountStore, int allowanceMaxAccountLimit, @NonNull ExpiryValidator expiryValidator) {
        Objects.requireNonNull(cryptoAllowances);
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(accountStore);
        for (CryptoAllowance allowance : cryptoAllowances) {
            AccountID owner = allowance.owner();
            AccountID spender = allowance.spenderOrThrow();
            Account effectiveOwner = CryptoApproveAllowanceHandler.getEffectiveOwnerAccount(owner, payerId, accountStore, expiryValidator);
            ArrayList<AccountCryptoAllowance> mutableAllowances = new ArrayList<AccountCryptoAllowance>(effectiveOwner.cryptoAllowances());
            long amount = allowance.amount();
            this.updateCryptoAllowance(mutableAllowances, amount, spender);
            Account copy = effectiveOwner.copyBuilder().cryptoAllowances(mutableAllowances).build();
            if (amount > 0L) {
                AllowanceValidator.validateAllowanceLimit(copy, allowanceMaxAccountLimit);
            }
            accountStore.put(copy);
        }
    }

    private void updateCryptoAllowance(List<AccountCryptoAllowance> mutableAllowances, long amount, AccountID spenderId) {
        AccountCryptoAllowance.Builder newAllowanceBuilder = AccountCryptoAllowance.newBuilder().spenderId(spenderId);
        int index = this.lookupSpender(mutableAllowances, spenderId);
        if (amount == 0L) {
            if (index != -1) {
                mutableAllowances.remove(index);
            }
            return;
        }
        if (index != -1) {
            mutableAllowances.set(index, newAllowanceBuilder.amount(amount).build());
        } else {
            mutableAllowances.add(newAllowanceBuilder.amount(amount).build());
        }
    }

    private void applyFungibleTokenAllowances(@NonNull List<TokenAllowance> tokenAllowances, @NonNull AccountID payerId, @NonNull WritableAccountStore accountStore, int allowanceMaxAccountLimit, @NonNull ExpiryValidator expiryValidator) {
        for (TokenAllowance allowance : tokenAllowances) {
            AccountID owner = allowance.owner();
            long amount = allowance.amount();
            TokenID tokenId = allowance.tokenIdOrThrow();
            AccountID spender = allowance.spenderOrThrow();
            Account effectiveOwner = CryptoApproveAllowanceHandler.getEffectiveOwnerAccount(owner, payerId, accountStore, expiryValidator);
            ArrayList<AccountFungibleTokenAllowance> mutableTokenAllowances = new ArrayList<AccountFungibleTokenAllowance>(effectiveOwner.tokenAllowances());
            this.updateTokenAllowance(mutableTokenAllowances, amount, spender, tokenId);
            Account copy = effectiveOwner.copyBuilder().tokenAllowances(mutableTokenAllowances).build();
            if (amount > 0L) {
                AllowanceValidator.validateAllowanceLimit(copy, allowanceMaxAccountLimit);
            }
            accountStore.put(copy);
        }
    }

    private void updateTokenAllowance(List<AccountFungibleTokenAllowance> mutableAllowances, long amount, AccountID spenderId, TokenID tokenId) {
        AccountFungibleTokenAllowance.Builder newAllowanceBuilder = AccountFungibleTokenAllowance.newBuilder().spenderId(spenderId).tokenId(tokenId);
        int index = this.lookupSpenderAndToken(mutableAllowances, spenderId, tokenId);
        if (amount == 0L) {
            if (index != -1) {
                mutableAllowances.remove(index);
            }
            return;
        }
        if (index != -1) {
            mutableAllowances.set(index, newAllowanceBuilder.amount(amount).build());
        } else {
            mutableAllowances.add(newAllowanceBuilder.amount(amount).build());
        }
    }

    protected void applyNftAllowances(List<NftAllowance> nftAllowances, @NonNull AccountID payerId, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenStore tokenStore, @NonNull WritableNftStore uniqueTokenStore, int allowanceMaxAccountLimit, @NonNull ExpiryValidator expiryValidator) {
        for (NftAllowance allowance : nftAllowances) {
            AccountID owner = allowance.owner();
            TokenID tokenId = allowance.tokenIdOrThrow();
            AccountID spender = allowance.spenderOrThrow();
            Account effectiveOwner = CryptoApproveAllowanceHandler.getEffectiveOwnerAccount(owner, payerId, accountStore, expiryValidator);
            ArrayList<AccountApprovalForAllAllowance> mutableNftAllowances = new ArrayList<AccountApprovalForAllAllowance>(effectiveOwner.approveForAllNftAllowances());
            if (allowance.hasApprovedForAll()) {
                AccountApprovalForAllAllowance approveForAllAllowance = AccountApprovalForAllAllowance.newBuilder().tokenId(tokenId).spenderId(spender).build();
                if (Boolean.TRUE.equals(allowance.approvedForAll())) {
                    if (!mutableNftAllowances.contains(approveForAllAllowance)) {
                        mutableNftAllowances.add(approveForAllAllowance);
                    }
                } else {
                    mutableNftAllowances.remove(approveForAllAllowance);
                }
                Account copy = effectiveOwner.copyBuilder().approveForAllNftAllowances(mutableNftAllowances).build();
                AllowanceValidator.validateAllowanceLimit(copy, allowanceMaxAccountLimit);
                accountStore.put(copy);
            }
            this.updateSpender(tokenStore, uniqueTokenStore, effectiveOwner, spender, tokenId, allowance.serialNumbers());
        }
    }

    public void updateSpender(@NonNull WritableTokenStore tokenStore, @NonNull WritableNftStore uniqueTokenStore, @NonNull Account owner, @NonNull AccountID spenderId, @NonNull TokenID tokenId, @NonNull List<Long> serialNums) {
        if (serialNums.isEmpty()) {
            return;
        }
        HashSet<Long> serialsSet = new HashSet<Long>(serialNums);
        for (Long serialNum : serialsSet) {
            NftID nftId = NftID.newBuilder().serialNumber(serialNum.longValue()).tokenId(tokenId).build();
            Nft nft = TokenHandlerHelper.getIfUsable(nftId, uniqueTokenStore);
            Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore, TokenHandlerHelper.TokenValidations.PERMIT_PAUSED);
            AccountID accountOwner = owner.accountId();
            HandleException.validateTrue((boolean)AllowanceValidator.isValidOwner(nft, accountOwner, token), (ResponseCodeEnum)ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO);
            Nft copy = nft.copyBuilder().spenderId(spenderId).build();
            uniqueTokenStore.put(copy);
        }
    }

    private int lookupSpender(List<AccountCryptoAllowance> ownerAllowances, AccountID spenderNum) {
        for (int i = 0; i < ownerAllowances.size(); ++i) {
            AccountCryptoAllowance allowance = ownerAllowances.get(i);
            if (!allowance.spenderId().equals((Object)spenderNum)) continue;
            return i;
        }
        return -1;
    }

    private int lookupSpenderAndToken(List<AccountFungibleTokenAllowance> ownerAllowances, AccountID spenderId, TokenID tokenId) {
        for (int i = 0; i < ownerAllowances.size(); ++i) {
            AccountFungibleTokenAllowance allowance = ownerAllowances.get(i);
            if (!allowance.spenderId().equals((Object)spenderId) || !allowance.tokenId().equals((Object)tokenId)) continue;
            return i;
        }
        return -1;
    }

    private static Account getEffectiveOwnerAccount(@Nullable AccountID owner, @NonNull AccountID payerId, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator) {
        long ownerNum;
        long l = ownerNum = owner != null ? owner.accountNumOrElse(Long.valueOf(0L)) : 0L;
        if (ownerNum == 0L || ownerNum == payerId.accountNumOrThrow()) {
            return accountStore.getAccountById(payerId);
        }
        return TokenHandlerHelper.getIfUsable(owner, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID);
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody body = feeContext.body();
        CryptoApproveAllowanceTransactionBody op = body.cryptoApproveAllowanceOrThrow();
        ReadableAccountStore accountStore = (ReadableAccountStore)feeContext.readableStore(ReadableAccountStore.class);
        long currentSecond = body.transactionIDOrThrow().transactionValidStartOrThrow().seconds();
        Account account = accountStore.getAccountById(feeContext.payer());
        long currentExpiry = account == null ? currentSecond : account.expirationSecond();
        long lifeTime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(currentSecond, currentExpiry);
        long adjustedBytes = this.getNewBytes(body.cryptoApproveAllowanceOrThrow(), account);
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).addBytesPerTransaction((long)this.bytesUsedInTxn(op)).addRamByteSeconds(adjustedBytes > 0L ? adjustedBytes * lifeTime : 0L).calculate();
    }

    private int bytesUsedInTxn(CryptoApproveAllowanceTransactionBody op) {
        return op.cryptoAllowances().size() * 36 + op.tokenAllowances().size() * 40 + op.nftAllowances().size() * 36 + this.countSerials(op.nftAllowances()) * 8;
    }

    private long getNewBytes(CryptoApproveAllowanceTransactionBody op, Account account) {
        long newCryptoKeys = this.getChangedCryptoKeys(op.cryptoAllowances(), account == null ? Collections.emptyList() : account.cryptoAllowances());
        long newTokenKeys = this.getChangedTokenKeys(op.tokenAllowances(), account == null ? Collections.emptyList() : account.tokenAllowances());
        long newApproveForAllNfts = this.getChangedNftKeys(op.nftAllowances(), account == null ? Collections.emptyList() : account.approveForAllNftAllowances());
        return newCryptoKeys * 36L + newTokenKeys * 40L + newApproveForAllNfts * 36L;
    }

    private int getChangedCryptoKeys(List<CryptoAllowance> newAllowances, List<AccountCryptoAllowance> existingAllowances) {
        int counter = 0;
        Set existingSpenders = existingAllowances.stream().map(AccountCryptoAllowance::spenderId).collect(Collectors.toSet());
        HashSet<AccountID> newSpenders = new HashSet<AccountID>();
        for (CryptoAllowance key : newAllowances) {
            if (existingSpenders.contains(key.spender()) || newSpenders.contains(key.spender())) continue;
            newSpenders.add(key.spender());
            ++counter;
        }
        return counter;
    }

    private int getChangedTokenKeys(List<TokenAllowance> newAllowances, List<AccountFungibleTokenAllowance> existingAllowances) {
        int counter = 0;
        Set existingKeys = existingAllowances.stream().map(key -> Pair.of((Object)key.tokenId(), (Object)key.spenderId())).collect(Collectors.toSet());
        HashSet<Pair> newKeys = new HashSet<Pair>();
        for (TokenAllowance key2 : newAllowances) {
            Pair newKey = Pair.of((Object)key2.tokenId(), (Object)key2.spender());
            if (existingKeys.contains(newKey) || newKeys.contains(newKey)) continue;
            newKeys.add(newKey);
            ++counter;
        }
        return counter;
    }

    private int getChangedNftKeys(List<NftAllowance> newAllowances, List<AccountApprovalForAllAllowance> existingAllowances) {
        int counter = 0;
        Set existingKeys = existingAllowances.stream().map(key -> Pair.of((Object)key.tokenId(), (Object)key.spenderId())).collect(Collectors.toSet());
        HashSet<Pair> newKeys = new HashSet<Pair>();
        for (NftAllowance key2 : newAllowances) {
            Pair newKey = Pair.of((Object)key2.tokenId(), (Object)key2.spender());
            if (existingKeys.contains(newKey) || newKeys.contains(newKey)) continue;
            newKeys.add(newKey);
            ++counter;
        }
        return counter;
    }

    private int countSerials(List<NftAllowance> nftAllowancesList) {
        int totalSerials = 0;
        for (NftAllowance allowance : nftAllowancesList) {
            totalSerials += allowance.serialNumbers().size();
        }
        return totalSerials;
    }
}

