/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Random;

public class RandomGraph {
    public static final int EVEN_MOD = 2;
    private final long seed;
    private final int degree;
    private int numVert;
    private Random random;
    private final Random random2;
    private boolean[][] adjacent;
    private int[][] neighbor;

    public RandomGraph(@NonNull Random random, int numVert, int degree, long seed) {
        if (degree < 0 || degree % 2 != 0) {
            throw new IllegalArgumentException("degree must non-negative and even");
        }
        this.degree = degree;
        this.seed = seed;
        this.random = new Random(seed);
        this.random2 = random;
        this.setNumVert(numVert);
    }

    public boolean isAdjacent(int x, int y) {
        if (x < 0 || y < 0 || x >= this.numVert || y >= this.numVert) {
            return false;
        }
        return this.adjacent[x][y];
    }

    public boolean[] getAdjacent(int vertex) {
        return this.adjacent[vertex];
    }

    public int randomNeighbor(int x) {
        if (this.numVert == 0 || this.degree == 0 || x < 0 || x >= this.numVert) {
            return 0;
        }
        return this.neighbor[x][this.random2.nextInt(this.neighbor[x].length)];
    }

    public int[] getNeighbors(int x) {
        return (int[])this.neighbor[x].clone();
    }

    private void setNumVertRecursive(int numVert) {
        int i;
        if (numVert == 0) {
            this.numVert = 0;
            this.adjacent = new boolean[0][0];
            this.random = new Random(this.seed);
            return;
        }
        if (numVert == this.numVert) {
            return;
        }
        if (this.degree >= numVert) {
            this.numVert = numVert;
            this.adjacent = new boolean[numVert][numVert];
            for (int i2 = 0; i2 < numVert; ++i2) {
                for (int j = 0; j < numVert; ++j) {
                    this.adjacent[i2][j] = i2 != j;
                }
            }
            return;
        }
        if (numVert != this.numVert + 1) {
            for (i = 0; i < numVert; ++i) {
                this.setNumVertRecursive(i);
            }
        }
        this.numVert = numVert;
        boolean[][] adj = new boolean[numVert][numVert];
        for (i = 0; i < numVert - 1; ++i) {
            System.arraycopy(this.adjacent[i], 0, adj[i], 0, numVert - 1);
        }
        if (this.degree >= numVert - 1) {
            for (i = 0; i < numVert - 1; ++i) {
                adj[i][numVert - 1] = true;
                adj[numVert - 1][i] = true;
            }
            this.adjacent = adj;
            return;
        }
        int numUnused = numVert - 1;
        int[] unused = new int[numUnused];
        for (i = 0; i < numUnused; ++i) {
            unused[i] = i;
        }
        for (i = 0; i < this.degree / 2; ++i) {
            int yi;
            int y;
            int xi;
            int x;
            while (!adj[x = unused[xi = this.random.nextInt(numUnused)]][y = unused[yi = this.random.nextInt(numUnused)]]) {
            }
            adj[x][y] = false;
            adj[y][x] = false;
            adj[x][numVert - 1] = true;
            adj[y][numVert - 1] = true;
            adj[numVert - 1][x] = true;
            adj[numVert - 1][y] = true;
            if (xi < yi) {
                int t = xi;
                xi = yi;
                yi = t;
            }
            unused[xi] = unused[numUnused - 1];
            unused[yi] = unused[numUnused - 2];
            numUnused -= 2;
        }
        this.adjacent = adj;
    }

    private void setNumVert(int numVert) {
        this.setNumVertRecursive(numVert);
        int numNeighbors = numVert == 0 ? 0 : (this.degree >= numVert ? numVert - 1 : this.degree);
        this.neighbor = new int[numVert][numNeighbors];
        for (int i = 0; i < numVert; ++i) {
            int j = 0;
            for (int k = 0; k < numVert; ++k) {
                if (!this.adjacent[i][k]) continue;
                this.neighbor[i][j] = k;
                ++j;
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.numVert; ++i) {
            int j;
            for (j = 0; j < this.numVert; ++j) {
                result.append(this.adjacent[i][j] ? " # " : " . ");
            }
            result.append("   ");
            for (j = 0; j < this.neighbor[i].length; ++j) {
                result.append(" ").append(this.neighbor[i][j]);
            }
            result.append("\n");
        }
        return result.toString();
    }
}

