/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.iss.internal;

import com.swirlds.common.utility.Mnemonics;
import com.swirlds.platform.metrics.IssMetrics;
import com.swirlds.platform.state.iss.internal.ConsensusHashStatus;
import com.swirlds.platform.state.iss.internal.HashPartition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hiero.base.crypto.Hash;
import org.hiero.base.utility.Threshold;
import org.hiero.consensus.model.node.NodeId;

public class ConsensusHashFinder {
    private final Map<Hash, HashPartition> partitionMap = new HashMap<Hash, HashPartition>();
    private final Set<NodeId> reportingNodes = new HashSet<NodeId>();
    private final long totalWeight;
    private final long round;
    private final IssMetrics issMetrics;
    private long hashReportedWeight;
    private HashPartition largestPartition;
    private ConsensusHashStatus status = ConsensusHashStatus.UNDECIDED;
    private Hash consensusHash;

    public ConsensusHashFinder(long round, long totalWeight, @NonNull IssMetrics issMetrics) {
        this.round = round;
        this.totalWeight = totalWeight;
        this.issMetrics = Objects.requireNonNull(issMetrics);
    }

    public ConsensusHashStatus getStatus() {
        return this.status;
    }

    public Hash getConsensusHash() {
        return this.consensusHash;
    }

    public void addHash(@NonNull NodeId nodeId, long nodeWeight, @NonNull Hash stateHash) {
        HashPartition partition;
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        Objects.requireNonNull(stateHash, "stateHash must not be null");
        if (!this.reportingNodes.add(nodeId)) {
            return;
        }
        if (this.partitionMap.containsKey(stateHash)) {
            partition = this.partitionMap.get(stateHash);
        } else {
            partition = new HashPartition(stateHash);
            this.partitionMap.put(stateHash, partition);
        }
        partition.addNodeHash(nodeId, nodeWeight);
        this.hashReportedWeight += nodeWeight;
        if (this.largestPartition == null || partition.getTotalWeight() > this.largestPartition.getTotalWeight()) {
            this.largestPartition = partition;
        }
        if (this.status != ConsensusHashStatus.UNDECIDED) {
            this.sendHashValidityDispatch(nodeId, stateHash);
            return;
        }
        if (Threshold.MAJORITY.isSatisfiedBy(this.largestPartition.getTotalWeight(), this.totalWeight)) {
            this.consensusHash = this.largestPartition.getHash();
            this.status = ConsensusHashStatus.DECIDED;
            this.sendHashValidityDispatchForAllNodes();
        } else {
            long remainingWeight = this.totalWeight - this.hashReportedWeight;
            if (!Threshold.MAJORITY.isSatisfiedBy(this.largestPartition.getTotalWeight() + remainingWeight, this.totalWeight)) {
                this.status = ConsensusHashStatus.CATASTROPHIC_ISS;
                this.issMetrics.catastrophicIssObserver(this.round);
            }
        }
    }

    private void sendHashValidityDispatch(@NonNull NodeId nodeId, @NonNull Hash stateHash) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        Objects.requireNonNull(stateHash, "stateHash must not be null");
        if (this.consensusHash != null) {
            this.issMetrics.stateHashValidityObserver(this.round, nodeId, stateHash, this.consensusHash);
        }
    }

    private void sendHashValidityDispatchForAllNodes() {
        for (HashPartition partition : this.partitionMap.values()) {
            for (NodeId nodeId : partition.getNodes()) {
                this.sendHashValidityDispatch(nodeId, partition.getHash());
            }
        }
    }

    public Map<Hash, HashPartition> getPartitionMap() {
        return this.partitionMap;
    }

    public boolean hasDisagreement() {
        return this.partitionMap.size() > 1;
    }

    public long getTotalWeight() {
        return this.totalWeight;
    }

    public long getHashReportedWeight() {
        return this.hashReportedWeight;
    }

    public void writePartitionData(StringBuilder sb) {
        sb.append("Nodes holding ").append(this.hashReportedWeight).append("/").append(this.totalWeight).append(" (").append((float)this.hashReportedWeight / (float)this.totalWeight * 100.0f).append("%) of total weight have reported a hash for round ").append(this.round).append(".\n");
        if (this.consensusHash != null) {
            sb.append("Consensus mnemonic: ").append(Mnemonics.generateMnemonic((Hash)this.consensusHash)).append("\n");
            sb.append("Consensus hash: ").append(this.consensusHash).append("\n");
        }
        ArrayList<HashPartition> partitions = new ArrayList<HashPartition>(this.partitionMap.size());
        partitions.addAll(this.partitionMap.values());
        partitions.sort((a, b) -> (int)(b.getTotalWeight() - a.getTotalWeight()));
        for (HashPartition partition : partitions) {
            sb.append("- node");
            if (partition.getNodes().size() != 1) {
                sb.append("s");
            }
            ArrayList<NodeId> nodes = new ArrayList<NodeId>(partition.getNodes().size());
            nodes.addAll(partition.getNodes());
            Collections.sort(nodes);
            boolean first = true;
            for (NodeId node : nodes) {
                if (first) {
                    sb.append(" ");
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(node);
            }
            sb.append("\n");
            long partitionWeight = partition.getTotalWeight();
            sb.append("  partition weight: ").append(partitionWeight).append(" (").append((float)partitionWeight / (float)this.totalWeight * 100.0f).append("% of total weight)\n");
            sb.append("  partition mnemonic: ").append(Mnemonics.generateMnemonic((Hash)partition.getHash())).append("\n");
            sb.append("  partition hash: ").append(partition.getHash()).append("\n");
        }
    }
}

