/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.utility;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;

public class ArrayUtils {
    public static int arrayCompare(@Nullable Bytes b1, @Nullable Bytes b2) {
        if (b1 == null && b2 == null) {
            return 0;
        }
        if (b1 == null && b2 != null) {
            return -1;
        }
        if (b1 != null && b2 == null) {
            return 1;
        }
        int i = 0;
        while ((long)i < Math.min(b1.length(), b2.length())) {
            if (b1.getByte((long)i) < b2.getByte((long)i)) {
                return -1;
            }
            if (b1.getByte((long)i) > b2.getByte((long)i)) {
                return 1;
            }
            ++i;
        }
        if (b1.length() < b2.length()) {
            return -1;
        }
        if (b1.length() > b2.length()) {
            return 1;
        }
        return 0;
    }

    public static int arrayCompare(@Nullable Bytes a1, @Nullable Bytes a2, byte[] whitening) {
        if (a1 == null && a2 == null) {
            return 0;
        }
        if (a1 != null && a2 == null) {
            return 1;
        }
        if (a1 == null && a2 != null) {
            return -1;
        }
        int maxLen = (int)Math.max(a1.length(), a2.length());
        int minLen = (int)Math.min(a1.length(), a2.length());
        if (whitening.length < maxLen) {
            whitening = Arrays.copyOf(whitening, maxLen);
        }
        for (int i = 0; i < minLen; ++i) {
            int b2;
            int b1 = a1.getByte((long)i) ^ whitening[i];
            if (b1 > (b2 = a2.getByte((long)i) ^ whitening[i])) {
                return 1;
            }
            if (b1 >= b2) continue;
            return -1;
        }
        if (a1.length() > a2.length()) {
            return 1;
        }
        if (a1.length() < a2.length()) {
            return -1;
        }
        return 0;
    }
}

