/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto.altbn128;

import java.math.BigInteger;
import org.hyperledger.besu.crypto.altbn128.AbstractFqp;
import org.hyperledger.besu.crypto.altbn128.Fq;

public class Fq2
extends AbstractFqp<Fq2> {
    private static final int DEGREE = 2;
    private static final Fq[] MODULUS_COEFFICIENTS = new Fq[]{Fq.create(1L), Fq.create(0L)};

    static final Fq2 zero() {
        return new Fq2(Fq.zero(), Fq.zero());
    }

    static final Fq2 one() {
        return new Fq2(Fq.one(), Fq.zero());
    }

    public static final Fq2 create(long c0, long c1) {
        return Fq2.create(BigInteger.valueOf(c0), BigInteger.valueOf(c1));
    }

    public static final Fq2 create(BigInteger c0, BigInteger c1) {
        return new Fq2(Fq.create(c0), Fq.create(c1));
    }

    private Fq2(Fq ... coefficients) {
        super(2, MODULUS_COEFFICIENTS, coefficients);
    }

    public static Fq2 b2() {
        Fq2 numerator = Fq2.create(3L, 0L);
        Fq2 denominator = Fq2.create(9L, 1L);
        return numerator.divide(denominator);
    }

    @Override
    protected Fq2 newInstance(Fq[] coefficients) {
        return new Fq2(coefficients);
    }
}

