/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2Frame;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Settings;

public record Http2Priority(boolean exclusive, int streamId, int weight) implements Http2Frame<Http2Flag.NoFlags>
{
    public static Http2Priority create(BufferData frame) {
        int streamDependencyWithFlag = frame.readInt32();
        boolean exclusive = (streamDependencyWithFlag & Integer.MIN_VALUE) != 0;
        int streamId = streamDependencyWithFlag & Integer.MAX_VALUE;
        int weight = frame.read() + 1;
        return new Http2Priority(exclusive, streamId, weight);
    }

    @Override
    public Http2FrameData toFrameData(Http2Settings settings, int forStreamId, Http2Flag.NoFlags flags) {
        BufferData data = BufferData.create((int)5);
        int streamDependency = this.streamId & Integer.MAX_VALUE;
        if (streamDependency != this.streamId) {
            throw new Http2Exception(Http2ErrorCode.INTERNAL, "Attempt to use 32bit integer for stream id, only 31 bits are allowed");
        }
        if (this.exclusive) {
            streamDependency = this.streamId | Integer.MIN_VALUE;
        }
        data.writeInt32(streamDependency);
        data.write(this.weight);
        Http2FrameHeader header = Http2FrameHeader.create(5, this.frameTypes(), flags, forStreamId);
        return new Http2FrameData(header, data);
    }

    @Override
    public String name() {
        return Http2FrameType.PRIORITY.name();
    }

    @Override
    public Http2FrameType frameType() {
        return Http2FrameType.PRIORITY;
    }

    @Override
    public Http2FrameTypes<Http2Flag.NoFlags> frameTypes() {
        return Http2FrameTypes.PRIORITY;
    }
}

