/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.gas;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.SubType;
import java.util.Objects;

public enum DispatchType {
    CRYPTO_CREATE(HederaFunctionality.CRYPTO_CREATE, SubType.DEFAULT),
    CRYPTO_UPDATE(HederaFunctionality.CRYPTO_UPDATE, SubType.DEFAULT),
    ETHEREUM_TRANSACTION(HederaFunctionality.ETHEREUM_TRANSACTION, SubType.DEFAULT),
    TRANSFER_HBAR(HederaFunctionality.CRYPTO_TRANSFER, SubType.DEFAULT),
    TRANSFER_FUNGIBLE(HederaFunctionality.CRYPTO_TRANSFER, SubType.TOKEN_FUNGIBLE_COMMON),
    TRANSFER_NFT(HederaFunctionality.CRYPTO_TRANSFER, SubType.TOKEN_NON_FUNGIBLE_UNIQUE),
    TRANSFER_FUNGIBLE_CUSTOM_FEES(HederaFunctionality.CRYPTO_TRANSFER, SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES),
    TRANSFER_NFT_CUSTOM_FEES(HederaFunctionality.CRYPTO_TRANSFER, SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES),
    MINT_FUNGIBLE(HederaFunctionality.TOKEN_MINT, SubType.TOKEN_FUNGIBLE_COMMON),
    MINT_NFT(HederaFunctionality.TOKEN_MINT, SubType.TOKEN_NON_FUNGIBLE_UNIQUE),
    BURN_FUNGIBLE(HederaFunctionality.TOKEN_BURN, SubType.TOKEN_FUNGIBLE_COMMON),
    DELETE(HederaFunctionality.TOKEN_DELETE, SubType.DEFAULT),
    BURN_NFT(HederaFunctionality.TOKEN_BURN, SubType.TOKEN_NON_FUNGIBLE_UNIQUE),
    ASSOCIATE(HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT, SubType.DEFAULT),
    DISSOCIATE(HederaFunctionality.TOKEN_DISSOCIATE_FROM_ACCOUNT, SubType.DEFAULT),
    APPROVE(HederaFunctionality.CRYPTO_APPROVE_ALLOWANCE, SubType.DEFAULT),
    DELETE_NFT_APPROVE(HederaFunctionality.CRYPTO_DELETE_ALLOWANCE, SubType.DEFAULT),
    GRANT_KYC(HederaFunctionality.TOKEN_GRANT_KYC_TO_ACCOUNT, SubType.DEFAULT),
    REVOKE_KYC(HederaFunctionality.TOKEN_REVOKE_KYC_FROM_ACCOUNT, SubType.DEFAULT),
    PAUSE(HederaFunctionality.TOKEN_PAUSE, SubType.DEFAULT),
    UNPAUSE(HederaFunctionality.TOKEN_UNPAUSE, SubType.DEFAULT),
    FREEZE(HederaFunctionality.TOKEN_FREEZE_ACCOUNT, SubType.DEFAULT),
    UNFREEZE(HederaFunctionality.TOKEN_UNFREEZE_ACCOUNT, SubType.DEFAULT),
    WIPE_FUNGIBLE(HederaFunctionality.TOKEN_ACCOUNT_WIPE, SubType.TOKEN_FUNGIBLE_COMMON),
    WIPE_NFT(HederaFunctionality.TOKEN_ACCOUNT_WIPE, SubType.TOKEN_NON_FUNGIBLE_UNIQUE),
    UPDATE(HederaFunctionality.TOKEN_UPDATE, SubType.DEFAULT),
    TOKEN_UPDATE_NFTS(HederaFunctionality.TOKEN_UPDATE_NFTS, SubType.DEFAULT),
    UTIL_PRNG(HederaFunctionality.UTIL_PRNG, SubType.DEFAULT),
    TOKEN_INFO(HederaFunctionality.TOKEN_GET_INFO, SubType.DEFAULT),
    UPDATE_TOKEN_CUSTOM_FEES(HederaFunctionality.TOKEN_FEE_SCHEDULE_UPDATE, SubType.DEFAULT),
    TOKEN_AIRDROP(HederaFunctionality.TOKEN_AIRDROP, SubType.DEFAULT),
    TOKEN_CLAIM_AIRDROP(HederaFunctionality.TOKEN_CLAIM_AIRDROP, SubType.DEFAULT),
    TOKEN_CANCEL_AIRDROP(HederaFunctionality.TOKEN_CANCEL_AIRDROP, SubType.DEFAULT),
    TOKEN_REJECT_FT(HederaFunctionality.TOKEN_REJECT, SubType.TOKEN_FUNGIBLE_COMMON),
    TOKEN_REJECT_NFT(HederaFunctionality.TOKEN_REJECT, SubType.TOKEN_NON_FUNGIBLE_UNIQUE),
    SCHEDULE_SIGN(HederaFunctionality.SCHEDULE_SIGN, SubType.DEFAULT),
    SCHEDULE_CREATE(HederaFunctionality.SCHEDULE_CREATE, SubType.DEFAULT),
    SCHEDULE_CREATE_CONTRACT_CALL(HederaFunctionality.SCHEDULE_CREATE, SubType.SCHEDULE_CREATE_CONTRACT_CALL),
    SCHEDULE_DELETE(HederaFunctionality.SCHEDULE_DELETE, SubType.DEFAULT),
    SCHEDULE_GET_INFO(HederaFunctionality.SCHEDULE_GET_INFO, SubType.DEFAULT);

    private final HederaFunctionality functionality;
    private final SubType subtype;

    private DispatchType(HederaFunctionality functionality, SubType subtype) {
        this.functionality = Objects.requireNonNull(functionality);
        this.subtype = Objects.requireNonNull(subtype);
    }

    public HederaFunctionality functionality() {
        return this.functionality;
    }

    public SubType subtype() {
        return this.subtype;
    }
}

