/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.ParserMode;
import java.util.Optional;

record MediaTypeImpl(String type, String subtype, String text) implements MediaType
{
    private static final System.Logger LOGGER = System.getLogger(MediaTypeImpl.class.getName());

    static MediaType parse(String fullType, ParserMode parserMode) {
        int slashIndex = fullType.indexOf(47);
        if (slashIndex < 1) {
            Optional<MediaType> maybeRelaxedType;
            if (parserMode == ParserMode.RELAXED && (maybeRelaxedType = ParserMode.findRelaxedMediaType(fullType)).isPresent()) {
                LOGGER.log(System.Logger.Level.DEBUG, () -> String.format("Invalid media type value \"%s\" replaced with \"%s\"", fullType, ((MediaType)maybeRelaxedType.get()).text()));
                return maybeRelaxedType.get();
            }
            throw new IllegalArgumentException("Cannot parse media type: " + fullType);
        }
        return new MediaTypeImpl(fullType.substring(0, slashIndex), fullType.substring(slashIndex + 1), fullType);
    }

    @Override
    public String toString() {
        return this.text();
    }
}

