/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.impl;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.state.hints.CRSStage;
import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.node.app.hints.HintsLibrary;
import com.hedera.node.app.hints.HintsService;
import com.hedera.node.app.hints.WritableHintsStore;
import com.hedera.node.app.hints.handlers.HintsHandlers;
import com.hedera.node.app.hints.impl.DaggerHintsServiceComponent;
import com.hedera.node.app.hints.impl.HintsContext;
import com.hedera.node.app.hints.impl.HintsController;
import com.hedera.node.app.hints.impl.HintsServiceComponent;
import com.hedera.node.app.hints.impl.OnHintsFinished;
import com.hedera.node.app.hints.schemas.V059HintsSchema;
import com.hedera.node.app.hints.schemas.V060HintsSchema;
import com.hedera.node.app.service.roster.impl.ActiveRosters;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HintsServiceImpl
implements HintsService,
OnHintsFinished {
    private static final Logger logger = LogManager.getLogger(HintsServiceImpl.class);
    private final HintsServiceComponent component;
    private final HintsLibrary library;
    @NonNull
    private final AtomicReference<Roster> currentRoster = new AtomicReference();
    @Nullable
    private OnHintsFinished cb;

    public HintsServiceImpl(@NonNull Metrics metrics, @NonNull Executor executor, @NonNull AppContext appContext, @NonNull HintsLibrary library, @NonNull Duration blockPeriod) {
        this.library = Objects.requireNonNull(library);
        this.component = DaggerHintsServiceComponent.factory().create(library, appContext, executor, metrics, this.currentRoster, blockPeriod, this);
    }

    @VisibleForTesting
    HintsServiceImpl(@NonNull HintsServiceComponent component, @NonNull HintsLibrary library) {
        this.component = Objects.requireNonNull(component);
        this.library = Objects.requireNonNull(library);
    }

    @Override
    public void initCurrentRoster(@NonNull Roster roster) {
        Objects.requireNonNull(roster);
        this.currentRoster.set(roster);
    }

    @Override
    public void onFinishedConstruction(@Nullable OnHintsFinished cb) {
        this.cb = cb;
    }

    @Override
    public void accept(@NonNull WritableHintsStore hintsStore, @NonNull HintsConstruction construction, @NonNull HintsContext context) {
        Objects.requireNonNull(hintsStore);
        Objects.requireNonNull(construction);
        Objects.requireNonNull(context);
        if (this.cb != null) {
            this.cb.accept(hintsStore, construction, context);
        }
    }

    @Override
    public boolean isReady() {
        return this.component.signingContext().isReady();
    }

    public Bytes verificationKey() {
        return this.component.signingContext().verificationKeyOrThrow();
    }

    @Override
    public HintsContext.Signing sign(@NonNull Bytes blockHash) {
        if (!this.isReady()) {
            throw new IllegalStateException("hinTS service not ready to sign block hash " + String.valueOf(blockHash));
        }
        HintsContext.Signing signing = this.component.signings().computeIfAbsent(blockHash, b -> this.component.signingContext().newSigning((Bytes)b, () -> this.component.signings().remove(blockHash)));
        this.component.submissions().submitPartialSignature(blockHash).exceptionally(t -> {
            logger.warn("Failed to submit partial signature for block hash {}", (Object)blockHash, t);
            return null;
        });
        return signing;
    }

    @Override
    @Nullable
    public HintsConstruction activeConstruction() {
        return this.component.signingContext().activeConstruction();
    }

    @Override
    public void handoff(@NonNull WritableHintsStore hintsStore, @NonNull Roster previousRoster, @NonNull Roster adoptedRoster, @NonNull Bytes adoptedRosterHash, boolean forceHandoff) {
        Objects.requireNonNull(hintsStore);
        Objects.requireNonNull(previousRoster);
        Objects.requireNonNull(adoptedRoster);
        Objects.requireNonNull(adoptedRosterHash);
        if (hintsStore.handoff(previousRoster, adoptedRoster, adoptedRosterHash, forceHandoff)) {
            HintsConstruction activeConstruction = Objects.requireNonNull(hintsStore.getActiveConstruction());
            this.component.signingContext().setConstruction(activeConstruction);
            logger.info("Updated hinTS construction in signing context to #{}", (Object)activeConstruction.constructionId());
        }
    }

    @Override
    public void reconcile(@NonNull ActiveRosters activeRosters, @NonNull WritableHintsStore hintsStore, @NonNull Instant now, @NonNull TssConfig tssConfig, boolean isActive) {
        Objects.requireNonNull(activeRosters);
        Objects.requireNonNull(hintsStore);
        Objects.requireNonNull(now);
        Objects.requireNonNull(tssConfig);
        switch (activeRosters.phase()) {
            case BOOTSTRAP: 
            case TRANSITION: {
                HintsConstruction construction = hintsStore.getOrCreateConstruction(activeRosters, now, tssConfig);
                if (construction.hasHintsScheme()) break;
                HintsController controller = this.component.controllers().getOrCreateFor(activeRosters, construction, hintsStore, this.activeConstruction());
                controller.advanceConstruction(now, hintsStore, isActive);
                break;
            }
        }
        this.currentRoster.set(activeRosters.findRelatedRoster(activeRosters.currentRosterHash()));
    }

    @Override
    public void executeCrsWork(@NonNull WritableHintsStore hintsStore, @NonNull Instant now, boolean isActive) {
        Objects.requireNonNull(hintsStore);
        Objects.requireNonNull(now);
        Optional<HintsController> controller = this.component.controllers().getAnyInProgress();
        if (controller.isEmpty()) {
            return;
        }
        if (hintsStore.getCrsState().stage() != CRSStage.COMPLETED) {
            controller.get().advanceCrsWork(now, hintsStore, isActive);
        }
    }

    @Override
    @NonNull
    public Bytes activeVerificationKeyOrThrow() {
        return this.component.signingContext().verificationKeyOrThrow();
    }

    @Override
    public HintsHandlers handlers() {
        return this.component.handlers();
    }

    @Override
    public void registerSchemas(@NonNull SchemaRegistry registry) {
        Objects.requireNonNull(registry);
        registry.register((Schema)new V059HintsSchema());
        registry.register((Schema)new V060HintsSchema(this.component.signingContext(), this.library));
    }

    @Override
    public void stop() {
        this.component.controllers().stop();
    }
}

