/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.validation;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.AutoRenewConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExpiryValidation {
    private final ConfigProvider configProvider;

    @Inject
    public ExpiryValidation(ConfigProvider configProvider) {
        this.configProvider = Objects.requireNonNull(configProvider, "configProvider must not be null");
    }

    public void checkAccountExpiry(@NonNull Account account) throws PreCheckException {
        if (account.tinybarBalance() > 0L || !account.expiredAndPendingRemoval()) {
            return;
        }
        AutoRenewConfig config = (AutoRenewConfig)this.configProvider.getConfiguration().getConfigData(AutoRenewConfig.class);
        if (account.smartContract()) {
            if (config.expireContracts()) {
                throw new PreCheckException(ResponseCodeEnum.CONTRACT_EXPIRED_AND_PENDING_REMOVAL);
            }
        } else if (config.expireAccounts()) {
            throw new PreCheckException(ResponseCodeEnum.ACCOUNT_EXPIRED_AND_PENDING_REMOVAL);
        }
    }
}

