/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.hooks;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessmentResult;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.ItemizedAssessedFee;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCalls;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookInvocation;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HooksABI;
import com.hedera.node.app.spi.workflows.HandleContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;

public class HookCallsFactory {
    @Inject
    public HookCallsFactory() {
    }

    public HookCalls from(@NonNull HandleContext handleContext, @NonNull CryptoTransferTransactionBody userTxn, @NonNull List<ItemizedAssessedFee> itemizedAssessedFees) {
        Objects.requireNonNull(handleContext);
        Objects.requireNonNull(userTxn);
        Objects.requireNonNull(itemizedAssessedFees);
        ReadableAccountStore accountStore = (ReadableAccountStore)handleContext.storeFactory().readableStore(ReadableAccountStore.class);
        String memo = handleContext.body().memo();
        long txnFee = handleContext.body().transactionFee();
        return this.getProposedTransfers(userTxn, accountStore, memo, txnFee, itemizedAssessedFees);
    }

    private HookCalls getProposedTransfers(@NonNull CryptoTransferTransactionBody userTxn, @NonNull ReadableAccountStore accountStore, @NonNull String memo, long txnFee, @NonNull List<ItemizedAssessedFee> itemizedAssessedFees) {
        ArrayList<HookInvocation> preOnly = new ArrayList<HookInvocation>();
        ArrayList<HookInvocation> prePost = new ArrayList<HookInvocation>();
        Tuple directTransfers = this.encodeTransfers(userTxn.transfersOrElse(TransferList.DEFAULT), userTxn.tokenTransfers(), accountStore, preOnly, prePost);
        Tuple customFeeTransfers = this.encodeCustomFees(accountStore, itemizedAssessedFees);
        return new HookCalls(new HookContext((Tuple)Tuple.of((Object)directTransfers, (Object)customFeeTransfers), memo, txnFee), preOnly, prePost);
    }

    private Tuple encodeCustomFees(@NonNull ReadableAccountStore accountStore, @NonNull List<ItemizedAssessedFee> itemizedAssessedFees) {
        if (itemizedAssessedFees.isEmpty()) {
            return HooksABI.EMPTY_TRANSFERS;
        }
        LinkedHashMap deltas = new LinkedHashMap();
        for (ItemizedAssessedFee assessedFee : itemizedAssessedFees) {
            AssessedCustomFee fee = assessedFee.assessedCustomFee();
            TokenID token = fee.hasTokenId() ? fee.tokenIdOrThrow() : AssessmentResult.HBAR_TOKEN_ID;
            Map map = deltas.computeIfAbsent(token, t -> new LinkedHashMap());
            map.merge(fee.feeCollectorAccountIdOrThrow(), fee.amount(), Long::sum);
            if (fee.effectivePayerAccountId().size() == 1) {
                AccountID payer = (AccountID)fee.effectivePayerAccountId().getFirst();
                map.merge(payer, -fee.amount(), Long::sum);
                continue;
            }
            if (assessedFee.multiPayerDeltas() == null) continue;
            for (Map.Entry<AccountID, Long> e : assessedFee.multiPayerDeltas().entrySet()) {
                Long payerDebits = e.getValue();
                map.merge(e.getKey(), payerDebits, Long::sum);
            }
        }
        Map<AccountID, Long> hbarMap = deltas.getOrDefault(AssessmentResult.HBAR_TOKEN_ID, Map.of());
        TransferList hbarTransfers = TransferList.newBuilder().accountAmounts(HookCallsFactory.toAccountAmounts(hbarMap)).build();
        List<TokenTransferList> tokenTransfers = deltas.entrySet().stream().filter(en -> !((TokenID)en.getKey()).equals((Object)AssessmentResult.HBAR_TOKEN_ID)).map(en -> TokenTransferList.newBuilder().token((TokenID)en.getKey()).transfers(HookCallsFactory.toAccountAmounts((Map)en.getValue())).build()).toList();
        return this.encodeTransfers(hbarTransfers, tokenTransfers, accountStore, List.of(), List.of());
    }

    private static List<AccountAmount> toAccountAmounts(@NonNull Map<AccountID, Long> map) {
        ArrayList<AccountAmount> out = new ArrayList<AccountAmount>(map.size());
        for (Map.Entry<AccountID, Long> e : map.entrySet()) {
            Long amt = e.getValue();
            if (amt == 0L) continue;
            out.add(AccountAmount.newBuilder().accountID(e.getKey()).amount(amt.longValue()).build());
        }
        return out;
    }

    private Tuple encodeTransfers(@NonNull TransferList hbarTransfers, @NonNull List<TokenTransferList> tokenTransfersList, @NonNull ReadableAccountStore accountStore, @NonNull List<HookInvocation> preOnly, @NonNull List<HookInvocation> prePost) {
        Tuple[] hbarXfers = this.encodeAccountAmounts(hbarTransfers.accountAmounts(), accountStore, preOnly, prePost);
        Tuple[] tokenTransfers = (Tuple[])tokenTransfersList.stream().map(ttl -> this.encodeTokenTransfers((TokenTransferList)ttl, accountStore, preOnly, prePost)).toArray(Tuple[]::new);
        return Tuple.of((Object)hbarXfers, (Object)tokenTransfers);
    }

    @NonNull
    private Tuple encodeTokenTransfers(@NonNull TokenTransferList ttl, @NonNull ReadableAccountStore accounts, @NonNull List<HookInvocation> preOnly, @NonNull List<HookInvocation> prePost) {
        Address tokenAddress = HookCallsFactory.headlongAddressOf(ttl.tokenOrThrow());
        Tuple[] transfers = this.encodeAccountAmounts(ttl.transfers(), accounts, preOnly, prePost);
        Tuple[] nftTransfers = this.encodeNftTransfers(ttl.nftTransfers(), accounts, preOnly, prePost);
        return Tuple.of((Object)tokenAddress, (Object)transfers, (Object)nftTransfers);
    }

    private Tuple[] encodeNftTransfers(@NonNull List<NftTransfer> nftTransfers, @NonNull ReadableAccountStore accounts, @NonNull List<HookInvocation> preOnly, @NonNull List<HookInvocation> prePost) {
        return (Tuple[])nftTransfers.stream().map(nft -> {
            HookCall hook;
            Address sender = HookCallsFactory.resolveAccountAddress(accounts, nft.senderAccountIDOrThrow());
            Address receiver = HookCallsFactory.resolveAccountAddress(accounts, nft.receiverAccountIDOrThrow());
            if (nft.hasPreTxSenderAllowanceHook()) {
                hook = nft.preTxSenderAllowanceHookOrThrow();
                preOnly.add(new HookInvocation(nft.senderAccountID(), hook.hookIdOrThrow(), sender, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            if (nft.hasPrePostTxSenderAllowanceHook()) {
                hook = nft.prePostTxSenderAllowanceHookOrThrow();
                prePost.add(new HookInvocation(nft.senderAccountID(), hook.hookIdOrThrow(), sender, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            if (nft.hasPreTxReceiverAllowanceHook()) {
                hook = nft.preTxReceiverAllowanceHookOrThrow();
                preOnly.add(new HookInvocation(nft.receiverAccountID(), hook.hookIdOrThrow(), receiver, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            if (nft.hasPrePostTxReceiverAllowanceHook()) {
                hook = nft.prePostTxReceiverAllowanceHookOrThrow();
                prePost.add(new HookInvocation(nft.receiverAccountID(), hook.hookIdOrThrow(), receiver, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            long serialNum = nft.serialNumber();
            return Tuple.of((Object)sender, (Object)receiver, (Object)serialNum);
        }).toArray(Tuple[]::new);
    }

    private Tuple[] encodeAccountAmounts(@NonNull List<AccountAmount> items, @NonNull ReadableAccountStore accountStore, @NonNull List<HookInvocation> preOnly, @NonNull List<HookInvocation> prePost) {
        return (Tuple[])items.stream().map(aa -> {
            HookCall hook;
            Address address = HookCallsFactory.resolveAccountAddress(accountStore, aa.accountIDOrThrow());
            long amount = aa.amount();
            if (aa.hasPreTxAllowanceHook()) {
                hook = aa.preTxAllowanceHookOrThrow();
                preOnly.add(new HookInvocation(aa.accountID(), hook.hookIdOrThrow(), address, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            if (aa.hasPrePostTxAllowanceHook()) {
                hook = aa.prePostTxAllowanceHookOrThrow();
                prePost.add(new HookInvocation(aa.accountID(), hook.hookIdOrThrow(), address, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            return Tuple.of((Object)address, (Object)amount);
        }).toArray(Tuple[]::new);
    }

    private static Address resolveAccountAddress(@NonNull ReadableAccountStore accountStore, @NonNull AccountID ownerId) {
        Account owner = accountStore.getAccountById(ownerId);
        return HookCallsFactory.priorityAddressOf(Objects.requireNonNull(owner));
    }

    private static Address priorityAddressOf(@NonNull Account account) {
        Objects.requireNonNull(account);
        return HookCallsFactory.asHeadlongAddress(HookCallsFactory.explicitAddressOf(account));
    }

    public static Address asHeadlongAddress(@NonNull byte[] explicit) {
        Objects.requireNonNull(explicit);
        BigInteger integralAddress = Bytes.wrap((byte[])explicit).toUnsignedBigInteger();
        return Address.wrap((String)Address.toChecksumAddress((BigInteger)integralAddress));
    }

    private static byte[] explicitAddressOf(@NonNull Account account) {
        Objects.requireNonNull(account);
        com.hedera.pbj.runtime.io.buffer.Bytes evmAddress = AliasUtils.extractEvmAddress((com.hedera.pbj.runtime.io.buffer.Bytes)account.alias());
        return evmAddress != null ? evmAddress.toByteArray() : CommonUtils.asEvmAddress((long)account.accountIdOrThrow().accountNumOrThrow());
    }

    public static Address headlongAddressOf(@NonNull TokenID tokenId) {
        Objects.requireNonNull(tokenId);
        return HookCallsFactory.asHeadlongAddress(CommonUtils.asEvmAddress((long)tokenId.tokenNum()));
    }
}

