/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config;

import com.hedera.node.config.VersionedConfiguration;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class VersionedConfigImpl
implements VersionedConfiguration {
    private final Configuration wrappedConfig;
    private final long version;

    public VersionedConfigImpl(@NonNull Configuration wrappedConfig, long version) {
        this.wrappedConfig = Objects.requireNonNull(wrappedConfig, "wrappedConfig must not be null");
        this.version = version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @NonNull
    public Stream<String> getPropertyNames() {
        return this.wrappedConfig.getPropertyNames();
    }

    public boolean exists(@NonNull String s) {
        return this.wrappedConfig.exists(s);
    }

    public boolean isListValue(@NonNull String propertyName) {
        return this.wrappedConfig.isListValue(propertyName);
    }

    public String getValue(@NonNull String s) throws NoSuchElementException {
        return this.wrappedConfig.getValue(s);
    }

    public String getValue(@NonNull String s, String s1) {
        return this.wrappedConfig.getValue(s, s1);
    }

    public <T> T getValue(@NonNull String s, @NonNull Class<T> aClass) throws NoSuchElementException, IllegalArgumentException {
        return (T)this.wrappedConfig.getValue(s, aClass);
    }

    public <T> T getValue(@NonNull String s, @NonNull Class<T> aClass, T t) throws IllegalArgumentException {
        return (T)this.wrappedConfig.getValue(s, aClass, t);
    }

    public List<String> getValues(@NonNull String s) {
        return this.wrappedConfig.getValues(s);
    }

    public List<String> getValues(@NonNull String s, List<String> list) {
        return this.wrappedConfig.getValues(s, list);
    }

    public <T> List<T> getValues(@NonNull String s, @NonNull Class<T> aClass) throws NoSuchElementException, IllegalArgumentException {
        return this.wrappedConfig.getValues(s, aClass);
    }

    public <T> List<T> getValues(@NonNull String s, @NonNull Class<T> aClass, List<T> list) throws IllegalArgumentException {
        return this.wrappedConfig.getValues(s, aClass, list);
    }

    @NonNull
    public <T extends Record> T getConfigData(@NonNull Class<T> aClass) {
        return (T)this.wrappedConfig.getConfigData(aClass);
    }

    @NonNull
    public Collection<Class<? extends Record>> getConfigDataTypes() {
        return this.wrappedConfig.getConfigDataTypes();
    }

    public Set<String> getValueSet(@NonNull String propertyName) {
        return this.wrappedConfig.getValueSet(propertyName);
    }

    public Set<String> getValueSet(@NonNull String propertyName, @Nullable Set<String> defaultValue) {
        return this.wrappedConfig.getValueSet(propertyName, defaultValue);
    }

    public <T> Set<T> getValueSet(@NonNull String propertyName, @NonNull Class<T> propertyType) throws NoSuchElementException, IllegalArgumentException {
        return this.wrappedConfig.getValueSet(propertyName, propertyType);
    }

    public <T> Set<T> getValueSet(@NonNull String propertyName, @NonNull Class<T> propertyType, @Nullable Set<T> defaultValue) throws IllegalArgumentException {
        return this.wrappedConfig.getValueSet(propertyName, propertyType, defaultValue);
    }
}

