/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metadata.hson;

import io.helidon.common.Builder;
import io.helidon.metadata.hson.HsonArray;
import io.helidon.metadata.hson.HsonException;
import io.helidon.metadata.hson.HsonParser;
import io.helidon.metadata.hson.HsonStruct;
import io.helidon.metadata.hson.HsonValues;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

public final class Hson {
    private Hson() {
    }

    public static Value<?> parse(InputStream inputStream) {
        return HsonParser.parse(inputStream);
    }

    public static Struct.Builder structBuilder() {
        return Struct.builder();
    }

    public static sealed interface Value<T>
    permits HsonValues.StringValue, HsonValues.NumberValue, HsonValues.BooleanValue, HsonValues.NullValue, Struct, Array {
        public void write(PrintWriter var1);

        public T value();

        public Type type();

        default public Array asArray() {
            if (this.type() != Type.ARRAY) {
                throw new HsonException("Attempting to read value of type " + String.valueOf((Object)this.type()) + " as an array");
            }
            return (Array)this;
        }

        default public Struct asStruct() {
            if (this.type() != Type.STRUCT) {
                throw new HsonException("Attempting to get value of type " + String.valueOf((Object)this.type()) + " as a Struct");
            }
            return (Struct)this;
        }
    }

    public static sealed interface Struct
    extends Value<Struct>
    permits HsonStruct {
        public static Builder builder() {
            return new HsonStruct.Builder();
        }

        public static Struct create() {
            return (Struct)Struct.builder().build();
        }

        public Optional<Value<?>> value(String var1);

        public Optional<Boolean> booleanValue(String var1);

        public boolean booleanValue(String var1, boolean var2);

        public Optional<Struct> structValue(String var1);

        public Optional<String> stringValue(String var1);

        public String stringValue(String var1, String var2);

        public Optional<Integer> intValue(String var1);

        public int intValue(String var1, int var2);

        public Optional<Double> doubleValue(String var1);

        public double doubleValue(String var1, double var2);

        public Optional<BigDecimal> numberValue(String var1);

        public BigDecimal numberValue(String var1, BigDecimal var2);

        public Optional<List<String>> stringArray(String var1);

        public Optional<List<Struct>> structArray(String var1);

        public Optional<List<BigDecimal>> numberArray(String var1);

        public Optional<List<Boolean>> booleanArray(String var1);

        public Optional<Array> arrayValue(String var1);

        public static interface Builder
        extends io.helidon.common.Builder<Builder, Struct> {
            public Builder unset(String var1);

            public Builder setNull(String var1);

            public Builder set(String var1, Value<?> var2);

            public Builder set(String var1, String var2);

            public Builder set(String var1, boolean var2);

            public Builder set(String var1, double var2);

            public Builder set(String var1, float var2);

            public Builder set(String var1, int var2);

            public Builder set(String var1, long var2);

            public Builder set(String var1, BigDecimal var2);

            public Builder set(String var1, Array var2);

            public Builder setStructs(String var1, List<Struct> var2);

            public Builder setStrings(String var1, List<String> var2);

            public Builder setLongs(String var1, List<Long> var2);

            public Builder setDoubles(String var1, List<Double> var2);

            public Builder setNumbers(String var1, List<BigDecimal> var2);

            public Builder setBooleans(String var1, List<Boolean> var2);
        }
    }

    public static sealed interface Array
    extends Value<List<Value<?>>>
    permits HsonArray {
        public static Array create() {
            return HsonArray.create();
        }

        public static Array create(List<? extends Value<?>> values) {
            return HsonArray.create(values);
        }

        public static Array createStrings(List<String> strings) {
            return HsonArray.createStrings(strings);
        }

        public static Array createNumbers(List<BigDecimal> numbers) {
            return HsonArray.createNumbers(numbers);
        }

        public static Array createBooleans(List<Boolean> booleans) {
            return HsonArray.createBooleans(booleans);
        }

        public static Array create(long ... values) {
            return HsonArray.create(values);
        }

        public static Array create(int ... values) {
            return HsonArray.create(values);
        }

        public static Array create(double ... values) {
            return HsonArray.create(values);
        }

        public static Array create(float ... values) {
            return HsonArray.create(values);
        }

        public List<String> getStrings();

        public List<Boolean> getBooleans();

        public List<BigDecimal> getNumbers();

        public List<Struct> getStructs();
    }

    public static enum Type {
        STRING,
        NUMBER,
        BOOLEAN,
        NULL,
        STRUCT,
        ARRAY;

    }
}

