/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.NoOpMetricsFactoryProvider;
import io.helidon.metrics.api.SeMetricsProgrammaticConfig;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.spi.MetersProvider;
import io.helidon.metrics.spi.MetricsFactoryProvider;
import io.helidon.metrics.spi.MetricsProgrammaticConfig;
import io.helidon.service.registry.Services;
import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;

class MetricsFactoryManager {
    private static final System.Logger LOGGER = System.getLogger(MetricsFactoryManager.class.getName());
    private static final LazyValue<MetricsFactoryProvider> METRICS_FACTORY_PROVIDER = LazyValue.create(() -> {
        MetricsFactoryProvider result = (MetricsFactoryProvider)HelidonServiceLoader.builder(ServiceLoader.load(MetricsFactoryProvider.class)).addService((Object)NoOpMetricsFactoryProvider.create(), Double.MIN_VALUE).build().iterator().next();
        LOGGER.log(System.Logger.Level.DEBUG, "Loaded metrics factory provider: {0}", result.getClass().getName());
        return result;
    });
    private static final LazyValue<Collection<MetricsProgrammaticConfig>> METRICS_CONFIG_OVERRIDES = LazyValue.create(() -> HelidonServiceLoader.builder(ServiceLoader.load(MetricsProgrammaticConfig.class)).addService((Object)new SeMetricsProgrammaticConfig(), 50.0).build().asList().reversed());
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final LazyValue<Collection<MetersProvider>> METER_PROVIDERS = LazyValue.create(() -> HelidonServiceLoader.create(ServiceLoader.load(MetersProvider.class)).asList());
    private static Config metricsConfigNode;
    private static MetricsFactory metricsFactory;

    private MetricsFactoryManager() {
    }

    static MetricsFactory getMetricsFactory(Config metricsConfigNode) {
        MetricsFactoryManager.metricsConfigNode = metricsConfigNode;
        MetricsConfig metricsConfig = MetricsConfig.create(metricsConfigNode);
        metricsFactory = MetricsFactoryManager.access(() -> MetricsFactoryManager.completeGetInstance(metricsConfig, metricsConfigNode));
        return metricsFactory;
    }

    static MetricsFactory getMetricsFactory() {
        return MetricsFactoryManager.access(() -> {
            metricsConfigNode = Objects.requireNonNullElseGet(metricsConfigNode, MetricsFactoryManager::externalMetricsConfig);
            metricsFactory = Objects.requireNonNullElseGet(metricsFactory, () -> MetricsFactoryManager.getMetricsFactory(metricsConfigNode));
            return metricsFactory;
        });
    }

    static MetricsFactory create(Config metricsConfigNode) {
        return ((MetricsFactoryProvider)METRICS_FACTORY_PROVIDER.get()).create(metricsConfigNode, MetricsConfig.create(metricsConfigNode.get("metrics")), (Collection)METER_PROVIDERS.get());
    }

    static void closeAll() {
        ((MetricsFactoryProvider)METRICS_FACTORY_PROVIDER.get()).close();
        metricsFactory = null;
    }

    private static Config externalMetricsConfig() {
        Config currentConfig = (Config)Services.get(Config.class);
        Config serverFeaturesMetricsConfig = currentConfig.get("server.features.observe.observers.metrics");
        if (!serverFeaturesMetricsConfig.exists()) {
            serverFeaturesMetricsConfig = currentConfig.get("metrics");
        }
        return serverFeaturesMetricsConfig;
    }

    private static MetricsFactory completeGetInstance(MetricsConfig metricsConfig, Config metricsConfigNode) {
        metricsConfig = MetricsFactoryManager.applyOverrides(metricsConfig);
        SystemTagsManager.instance(metricsConfig);
        metricsFactory = ((MetricsFactoryProvider)METRICS_FACTORY_PROVIDER.get()).create(metricsConfigNode, metricsConfig, (Collection)METER_PROVIDERS.get());
        return metricsFactory;
    }

    private static MetricsConfig applyOverrides(MetricsConfig metricsConfig) {
        MetricsConfig.Builder metricsConfigBuilder = MetricsConfig.builder(metricsConfig);
        ((Collection)METRICS_CONFIG_OVERRIDES.get()).forEach(override -> override.apply(metricsConfigBuilder));
        return metricsConfigBuilder.build();
    }

    private static <T> T access(Callable<T> c) {
        LOCK.lock();
        try {
            T t = c.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            LOCK.unlock();
        }
    }
}

