/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.burn;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.burn.BurnDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BurnTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod BURN_TOKEN_V1 = SystemContractMethod.declare("burnToken(address,uint64,int64[])", "(int64,int64)").withVariant(SystemContractMethod.Variant.V1).withCategories(SystemContractMethod.Category.MINT_BURN);
    public static final SystemContractMethod BURN_TOKEN_V2 = SystemContractMethod.declare("burnToken(address,int64,int64[])", "(int64,int64)").withVariant(SystemContractMethod.Variant.V2).withCategories(SystemContractMethod.Category.MINT_BURN);
    BurnDecoder decoder;

    @Inject
    public BurnTranslator(@NonNull BurnDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(BURN_TOKEN_V1, BURN_TOKEN_V2);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(BURN_TOKEN_V1, BURN_TOKEN_V2);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        TransactionBody body;
        boolean isFungibleMint = (body = this.bodyForClassic(attempt)).tokenBurnOrThrow().serialNumbers().isEmpty();
        return new DispatchForResponseCodeHtsCall(attempt, body, isFungibleMint ? BurnTranslator::fungibleBurnGasRequirement : BurnTranslator::nftBurnGasRequirement, BurnDecoder.BURN_OUTPUT_FN);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(BURN_TOKEN_V1)) {
            return this.decoder.decodeBurn(attempt);
        }
        return this.decoder.decodeBurnV2(attempt);
    }

    public static long fungibleBurnGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.BURN_FUNGIBLE, payerId);
    }

    public static long nftBurnGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.BURN_NFT, payerId);
    }
}

