/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.symbol;

import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.symbol.SymbolCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SymbolTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod SYMBOL = SystemContractMethod.declare("symbol()", "(string)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ERC20, SystemContractMethod.Category.ERC721, SystemContractMethod.Category.TOKEN_QUERY);

    @Inject
    public SymbolTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(SYMBOL);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(SYMBOL);
    }

    public SymbolCall callFrom(@NonNull HtsCallAttempt attempt) {
        return new SymbolCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.redirectToken());
    }
}

