/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.hapi.utils.fee.SmartContractFeeBuilder;
import com.hedera.node.app.service.contract.impl.ContractServiceComponent;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.exec.TransactionComponent;
import com.hedera.node.app.service.contract.impl.handlers.AbstractContractTransactionHandler;
import com.hedera.node.app.service.contract.impl.records.ContractCreateStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.HookDispatchUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@Singleton
public class ContractCreateHandler
extends AbstractContractTransactionHandler {
    private static final AccountID REMOVE_AUTO_RENEW_ACCOUNT_SENTINEL = AccountID.newBuilder().shardNum(0L).realmNum(0L).accountNum(0L).build();

    @Inject
    public ContractCreateHandler(@NonNull Provider<TransactionComponent.Factory> provider, @NonNull GasCalculator gasCalculator, @NonNull EntityIdFactory entityIdFactory, @NonNull ContractServiceComponent component) {
        super(provider, gasCalculator, entityIdFactory, component);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        TransactionComponent component = this.getTransactionComponent(context, HederaFunctionality.CONTRACT_CREATE);
        CallOutcome outcome = component.contextTransactionProcessor().call();
        ContractCreateStreamBuilder streamBuilder = (ContractCreateStreamBuilder)context.savepointStack().getBaseBuilder(ContractCreateStreamBuilder.class);
        outcome.addCreateDetailsTo(streamBuilder, context, this.entityIdFactory);
        ConversionUtils.throwIfUnsuccessfulCreate(outcome, component.hederaOperations());
        this.createHooksIfAny(context, Objects.requireNonNull(outcome.recipientIdIfCreated()));
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        try {
            TransactionBody txn = context.body();
            ContractCreateTransactionBody op = txn.contractCreateInstanceOrThrow();
            long intrinsicGas = this.gasCalculator.transactionIntrinsicGasCost(Bytes.wrap((byte[])new byte[0]), true, 0L);
            PreCheckException.validateTruePreCheck((op.gas() >= intrinsicGas ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
            HookDispatchUtils.validateHookDuplicates((List)op.hookCreationDetails());
        }
        catch (Exception e) {
            this.bumpExceptionMetrics(HederaFunctionality.CONTRACT_CREATE, e);
            throw e;
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        AccountID autoRenewAccountID;
        Key adminKey;
        Objects.requireNonNull(context);
        ContractCreateTransactionBody op = context.body().contractCreateInstanceOrThrow();
        if (op.hasAdminKey() && !(adminKey = op.adminKeyOrThrow()).hasContractID()) {
            context.requireKey(adminKey);
        }
        if (op.hasAutoRenewAccountId() && !(autoRenewAccountID = op.autoRenewAccountIdOrThrow()).equals((Object)REMOVE_AUTO_RENEW_ACCOUNT_SENTINEL)) {
            context.requireKeyOrThrow(autoRenewAccountID, ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        }
    }

    @Override
    @NonNull
    protected FeeData getFeeMatrices(@NonNull SmartContractFeeBuilder usageEstimator, @NonNull com.hederahashgraph.api.proto.java.TransactionBody txBody, @NonNull SigValueObj sigValObj) {
        return usageEstimator.getContractCreateTxFeeMatrices(txBody, sigValObj);
    }

    private void createHooksIfAny(@NonNull HandleContext context, ContractID owner) {
        ContractCreateTransactionBody op = context.body().contractCreateInstanceOrThrow();
        if (!op.hookCreationDetails().isEmpty()) {
            ReadableAccountStore accountStore = (ReadableAccountStore)context.storeFactory().readableStore(ReadableAccountStore.class);
            Account created = Objects.requireNonNull(accountStore.getContractById(owner));
            int deltaSlots = HookDispatchUtils.dispatchHookCreations((HandleContext)context, (List)op.hookCreationDetails(), null, (AccountID)created.accountId());
            Account updated = created.copyBuilder().firstHookId(((HookCreationDetails)op.hookCreationDetails().getFirst()).hookId()).numberHooksInUse((long)op.hookCreationDetails().size()).numberLambdaStorageSlots(created.numberLambdaStorageSlots() + (long)deltaSlots).build();
            ((TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class)).updateContract(updated);
        }
    }
}

