/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.store;

import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityIdStore;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.store.ServiceApiFactory;
import com.hedera.node.app.store.WritableStoreFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;

public class StoreFactoryImpl
implements StoreFactory {
    private final ReadableStoreFactory readableStoreFactory;
    private final WritableStoreFactory writableStoreFactory;
    private final ServiceApiFactory serviceApiFactory;

    public static StoreFactory from(@NonNull State state, @NonNull String serviceName, @NonNull Configuration configuration, @NonNull WritableEntityIdStore writableEntityIdStoreImpl, @NonNull Map<Class<?>, ServiceApiProvider<?>> apiProviders) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(serviceName);
        return new StoreFactoryImpl(new ReadableStoreFactory(state), new WritableStoreFactory(state, serviceName, (WritableEntityCounters)writableEntityIdStoreImpl), new ServiceApiFactory(state, configuration, apiProviders));
    }

    public StoreFactoryImpl(@NonNull ReadableStoreFactory readableStoreFactory, @NonNull WritableStoreFactory writableStoreFactory, @NonNull ServiceApiFactory serviceApiFactory) {
        this.readableStoreFactory = Objects.requireNonNull(readableStoreFactory);
        this.writableStoreFactory = Objects.requireNonNull(writableStoreFactory);
        this.serviceApiFactory = Objects.requireNonNull(serviceApiFactory);
    }

    @NonNull
    public <T> T readableStore(@NonNull Class<T> storeInterface) {
        Objects.requireNonNull(storeInterface);
        return this.readableStoreFactory.getStore(storeInterface);
    }

    @NonNull
    public <T> T writableStore(@NonNull Class<T> storeInterface) {
        Objects.requireNonNull(storeInterface);
        return this.writableStoreFactory.getStore(storeInterface);
    }

    @NonNull
    public <T> T serviceApi(@NonNull Class<T> apiInterface) {
        Objects.requireNonNull(apiInterface);
        return this.serviceApiFactory.getApi(apiInterface);
    }

    public ReadableStoreFactory asReadOnly() {
        return this.readableStoreFactory;
    }
}

