/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.node.app.hapi.utils.throttles.CongestibleThrottle;
import com.hedera.node.app.hapi.utils.throttles.DeterministicThrottle;
import com.hedera.node.app.hapi.utils.throttles.LeakyBucketDeterministicThrottle;
import com.hedera.node.app.hapi.utils.throttles.OpsDurationDeterministicThrottle;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.config.data.StatsConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThrottleMetrics {
    private static final Logger log = LogManager.getLogger(ThrottleMetrics.class);
    private static final String GAS_THROTTLE_ID = "<GAS>";
    private static final String BYTES_THROTTLE_ID = "<GAS>";
    private static final String OPS_DURATION_ID = "<OPS_DURATION>";
    private final Metrics metrics;
    private final String nameTemplate;
    private final String descriptionTemplate;
    private final Function<StatsConfig, List<String>> throttlesToSampleSupplier;
    private List<MetricPair> liveMetricPairs = List.of();
    private MetricPair gasThrottleMetricPair;
    private MetricPair opsDurationThrottleMetricPair;

    public ThrottleMetrics(@NonNull Metrics metrics, @NonNull ThrottleAccumulator.ThrottleType throttleType) {
        this.metrics = Objects.requireNonNull(metrics);
        String typePrefix = Objects.requireNonNull(throttleType) == ThrottleAccumulator.ThrottleType.FRONTEND_THROTTLE ? "HAPI" : "cons";
        this.nameTemplate = typePrefix.toLowerCase() + "%sPercentUsed";
        this.descriptionTemplate = "instantaneous %% used in " + typePrefix + " %s throttle bucket";
        this.throttlesToSampleSupplier = throttleType == ThrottleAccumulator.ThrottleType.FRONTEND_THROTTLE ? StatsConfig::hapiThrottlesToSample : StatsConfig::consThrottlesToSample;
    }

    public void setupThrottleMetrics(@NonNull List<DeterministicThrottle> throttles, @NonNull Configuration configuration) {
        StatsConfig statsConfig = (StatsConfig)configuration.getConfigData(StatsConfig.class);
        List<String> throttlesToSample = this.throttlesToSampleSupplier.apply(statsConfig);
        this.liveMetricPairs = throttles.stream().filter(throttle -> throttlesToSample.contains(throttle.name())).map(this::setupLiveMetricPair).toList();
        Set<String> throttlesExcludedFromInertMetrics = Set.of("<GAS>", OPS_DURATION_ID);
        Set throttleNames = throttles.stream().map(DeterministicThrottle::name).collect(Collectors.toSet());
        throttlesToSample.stream().filter(name -> !throttleNames.contains(name) && !throttlesExcludedFromInertMetrics.contains(name)).forEach(this::setupInertMetric);
    }

    public void setupGasThrottleMetric(@NonNull LeakyBucketDeterministicThrottle gasThrottle, @NonNull Configuration configuration) {
        StatsConfig statsConfig = (StatsConfig)configuration.getConfigData(StatsConfig.class);
        List<String> throttlesToSample = this.throttlesToSampleSupplier.apply(statsConfig);
        this.gasThrottleMetricPair = throttlesToSample.contains("<GAS>") ? this.setupLiveMetricPair((CongestibleThrottle)gasThrottle) : null;
    }

    public void setupBytesThrottleMetric(@NonNull LeakyBucketDeterministicThrottle bytesThrottle, @NonNull Configuration configuration) {
        StatsConfig statsConfig = (StatsConfig)configuration.getConfigData(StatsConfig.class);
        List<String> throttlesToSample = this.throttlesToSampleSupplier.apply(statsConfig);
        this.gasThrottleMetricPair = throttlesToSample.contains("<GAS>") ? this.setupLiveMetricPair((CongestibleThrottle)bytesThrottle) : null;
    }

    public void setupOpsDurationMetric(@NonNull OpsDurationDeterministicThrottle opsDurationThrottle, @NonNull Configuration configuration) {
        StatsConfig statsConfig = (StatsConfig)configuration.getConfigData(StatsConfig.class);
        List<String> throttlesToSample = this.throttlesToSampleSupplier.apply(statsConfig);
        this.opsDurationThrottleMetricPair = throttlesToSample.contains(OPS_DURATION_ID) ? this.setupLiveMetricPair((CongestibleThrottle)opsDurationThrottle) : null;
    }

    public void updateAllMetrics() {
        for (MetricPair metricPair : this.liveMetricPairs) {
            metricPair.gauge().set(metricPair.throttle().instantaneousPercentUsed());
        }
        if (this.gasThrottleMetricPair != null) {
            this.gasThrottleMetricPair.gauge().set(this.gasThrottleMetricPair.throttle().instantaneousPercentUsed());
        }
        if (this.opsDurationThrottleMetricPair != null) {
            this.opsDurationThrottleMetricPair.gauge().set(this.opsDurationThrottleMetricPair.throttle().instantaneousPercentUsed());
        }
    }

    private MetricPair setupLiveMetricPair(@NonNull CongestibleThrottle throttle) {
        DoubleGauge gauge = this.setupMetric(throttle.name(), "LIVE");
        return new MetricPair(throttle, gauge);
    }

    private void setupInertMetric(@NonNull String throttleName) {
        this.setupMetric(throttleName, "INERT");
    }

    private DoubleGauge setupMetric(@NonNull String throttleName, @NonNull String status) {
        String name = String.format(this.nameTemplate, throttleName);
        String description = String.format(this.descriptionTemplate, throttleName);
        DoubleGauge.Config config = new DoubleGauge.Config("app", name).withDescription(description).withFormat("%,13.2f");
        DoubleGauge gauge = (DoubleGauge)this.metrics.getOrCreate((MetricConfig)config);
        log.info("Registered {} gauge for '{}' under name '{}'", (Object)status, (Object)description, (Object)name);
        return gauge;
    }

    private record MetricPair(CongestibleThrottle throttle, DoubleGauge gauge) {
    }
}

