/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.ModificationNotAllowedException;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.account.MutableAccount;

public class UpdateTrackingAccount<A extends Account>
implements MutableAccount {
    private final Address address;
    private final Hash addressHash;
    @Nullable
    private A account;
    private boolean immutable;
    private long nonce;
    private Wei balance;
    @Nullable
    private Bytes updatedCode;
    private final Bytes oldCode;
    @Nullable
    private Hash updatedCodeHash;
    private final Hash oldCodeHash;
    private final NavigableMap<UInt256, UInt256> updatedStorage;
    private boolean storageWasCleared = false;
    private boolean transactionBoundary = false;

    UpdateTrackingAccount(Address address) {
        Preconditions.checkNotNull((Object)address);
        this.address = address;
        this.addressHash = this.address.addressHash();
        this.account = null;
        this.nonce = 0L;
        this.balance = Wei.ZERO;
        this.updatedCode = Bytes.EMPTY;
        this.oldCode = Bytes.EMPTY;
        this.oldCodeHash = Hash.EMPTY;
        this.updatedStorage = new TreeMap<UInt256, UInt256>();
    }

    public UpdateTrackingAccount(A account) {
        Preconditions.checkNotNull(account);
        this.address = account.getAddress();
        this.addressHash = account instanceof UpdateTrackingAccount ? ((UpdateTrackingAccount)account).addressHash : this.address.addressHash();
        this.account = account;
        this.nonce = account.getNonce();
        this.balance = account.getBalance();
        this.oldCode = account.getCode();
        this.oldCodeHash = account.getCodeHash();
        this.updatedStorage = new TreeMap<UInt256, UInt256>();
    }

    public A getWrappedAccount() {
        return this.account;
    }

    public void setWrappedAccount(A account) {
        if (this.account != null) {
            throw new IllegalStateException("Already tracking a wrapped account");
        }
        this.account = account;
        this.storageWasCleared = false;
    }

    public boolean codeWasUpdated() {
        return this.updatedCode != null;
    }

    @Override
    public Map<UInt256, UInt256> getUpdatedStorage() {
        return this.updatedStorage;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public Hash getAddressHash() {
        return this.addressHash;
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public void setNonce(long value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.nonce = value;
    }

    @Override
    public Wei getBalance() {
        return this.balance;
    }

    @Override
    public void setBalance(Wei value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.balance = value;
    }

    @Override
    public Bytes getCode() {
        return this.updatedCode == null ? this.oldCode : this.updatedCode;
    }

    @Override
    public Hash getCodeHash() {
        if (this.updatedCode == null) {
            return this.oldCodeHash;
        }
        if (this.updatedCodeHash == null) {
            this.updatedCodeHash = Hash.hash((Bytes)this.updatedCode);
        }
        return this.updatedCodeHash;
    }

    @Override
    public boolean hasCode() {
        return this.updatedCode == null ? !this.oldCode.isEmpty() : !this.updatedCode.isEmpty();
    }

    @Override
    public void setCode(Bytes code) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.updatedCode = code;
        this.updatedCodeHash = null;
    }

    void markTransactionBoundary() {
        this.transactionBoundary = true;
    }

    @Override
    public UInt256 getStorageValue(UInt256 key) {
        UInt256 value = (UInt256)this.updatedStorage.get(key);
        if (value != null) {
            return value;
        }
        if (this.storageWasCleared) {
            return UInt256.ZERO;
        }
        return this.account == null ? UInt256.ZERO : this.account.getStorageValue(key);
    }

    @Override
    public UInt256 getOriginalStorageValue(UInt256 key) {
        if (this.transactionBoundary) {
            return this.getStorageValue(key);
        }
        if (this.storageWasCleared || this.account == null) {
            return UInt256.ZERO;
        }
        return this.account.getOriginalStorageValue(key);
    }

    @Override
    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 startKeyHash, int limit) {
        NavigableMap<Object, Object> entries = this.account != null ? this.account.storageEntriesFrom(startKeyHash, limit) : new TreeMap();
        this.updatedStorage.entrySet().stream().map(entry -> AccountStorageEntry.forKeyAndValue((UInt256)entry.getKey(), (UInt256)entry.getValue())).filter(entry -> entry.getKeyHash().compareTo((Bytes)startKeyHash) >= 0).forEach(entry -> entries.put(entry.getKeyHash(), entry));
        while (entries.size() > limit) {
            entries.remove(entries.lastKey());
        }
        return entries;
    }

    @Override
    public void setStorageValue(UInt256 key, UInt256 value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.updatedStorage.put(key, value);
    }

    @Override
    public void clearStorage() {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.storageWasCleared = true;
        this.updatedStorage.clear();
    }

    @Override
    public boolean isStorageEmpty() {
        return this.updatedStorage.isEmpty() && (this.storageWasCleared || this.account == null || this.account.isStorageEmpty());
    }

    @Override
    public void becomeImmutable() {
        this.immutable = true;
    }

    public boolean getStorageWasCleared() {
        return this.storageWasCleared;
    }

    public void setStorageWasCleared(boolean storageWasCleared) {
        this.storageWasCleared = storageWasCleared;
    }

    public String toString() {
        String storage;
        String string = storage = this.updatedStorage.isEmpty() ? "[not updated]" : this.updatedStorage.toString();
        if (this.updatedStorage.isEmpty() && this.storageWasCleared) {
            storage = "[cleared]";
        }
        return String.format("%s -> {nonce: %s, balance:%s, code:%s, storage:%s }", this.address, this.nonce, this.balance, this.updatedCode == null ? "[not updated]" : this.updatedCode, storage);
    }
}

