/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenUnfreezeAccountTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsageUtils;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenUnfreezeMeta;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenUnfreezeAccountHandler
implements TransactionHandler {
    @Inject
    public TokenUnfreezeAccountHandler() {
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenUnfreezeAccountTransactionBody op = context.body().tokenUnfreezeOrThrow();
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableTokenStore.TokenMetadata tokenMeta = tokenStore.getTokenMeta(op.tokenOrElse(TokenID.DEFAULT));
        if (tokenMeta == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (!tokenMeta.hasFreezeKey()) {
            throw new PreCheckException(ResponseCodeEnum.TOKEN_HAS_NO_FREEZE_KEY);
        }
        context.requireKey(tokenMeta.freezeKey());
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        TokenUnfreezeAccountTransactionBody op = context.body().tokenUnfreezeOrThrow();
        StoreFactory storeFactory = context.storeFactory();
        ReadableAccountStore accountStore = (ReadableAccountStore)storeFactory.readableStore(ReadableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)storeFactory.readableStore(ReadableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        ExpiryValidator expiryValidator = context.expiryValidator();
        TokenRelation tokenRel = this.validateSemantics(op, accountStore, tokenStore, tokenRelStore, expiryValidator);
        TokenRelation.Builder copyBuilder = tokenRel.copyBuilder();
        copyBuilder.frozen(false);
        tokenRelStore.put(copyBuilder.build());
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenUnfreezeAccountTransactionBody op = txn.tokenUnfreezeOrThrow();
        if (!op.hasToken()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (!op.hasAccount()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
    }

    private TokenRelation validateSemantics(@NonNull TokenUnfreezeAccountTransactionBody op, @NonNull ReadableAccountStore accountStore, @NonNull ReadableTokenStore tokenStore, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull ExpiryValidator expiryValidator) throws HandleException {
        TokenID tokenId = op.tokenOrElse(TokenID.DEFAULT);
        TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
        ReadableTokenStore.TokenMetadata tokenMeta = tokenStore.getTokenMeta(tokenId);
        HandleException.validateTrue((tokenMeta != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        HandleException.validateTrue((boolean)tokenMeta.hasFreezeKey(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_FREEZE_KEY);
        AccountID accountId = op.accountOrElse(AccountID.DEFAULT);
        Account account = TokenHandlerHelper.getIfUsable(accountId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ACCOUNT_ID);
        TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
        TokenRelation tokenRel = tokenRelStore.get(accountId, tokenId);
        HandleException.validateTrue((tokenRel != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT);
        return tokenRel;
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TokenUnfreezeMeta meta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenUnfreezeUsageFrom();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).addBytesPerTransaction((long)meta.getBpt()).calculate();
    }
}

