/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.common.configurable.ObserverManager;
import io.helidon.common.configurable.ScheduledThreadPoolConfig;
import io.helidon.common.context.Contexts;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=ScheduledThreadPoolConfig.class)
public final class ScheduledThreadPoolSupplier
implements Supplier<ScheduledExecutorService>,
RuntimeType.Api<ScheduledThreadPoolConfig> {
    private final int corePoolSize;
    private final boolean isDaemon;
    private final String threadNamePrefix;
    private final boolean prestart;
    private final LazyValue<ScheduledExecutorService> lazyValue = LazyValue.create(() -> Contexts.wrap((ScheduledExecutorService)this.getThreadPool()));
    private final ScheduledThreadPoolConfig config;

    private ScheduledThreadPoolSupplier(ScheduledThreadPoolConfig config) {
        this.config = config;
        this.corePoolSize = config.corePoolSize();
        this.isDaemon = config.daemon();
        this.threadNamePrefix = config.threadNamePrefix();
        this.prestart = config.prestart();
        ObserverManager.registerSupplier(this, "scheduled", this.threadNamePrefix);
    }

    public static ScheduledThreadPoolConfig.Builder builder() {
        return ScheduledThreadPoolConfig.builder();
    }

    public static ScheduledThreadPoolSupplier create(Config config) {
        return ((ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolSupplier.builder().config(config)).build();
    }

    public static ScheduledThreadPoolSupplier create() {
        return ScheduledThreadPoolSupplier.builder().build();
    }

    public static ScheduledThreadPoolSupplier create(ScheduledThreadPoolConfig config) {
        return new ScheduledThreadPoolSupplier(config);
    }

    public static ScheduledThreadPoolSupplier create(Consumer<ScheduledThreadPoolConfig.Builder> consumer) {
        return ((ScheduledThreadPoolConfig.Builder)ScheduledThreadPoolConfig.builder().update(consumer)).build();
    }

    public ScheduledThreadPoolConfig prototype() {
        return this.config;
    }

    public int corePoolSize() {
        return this.corePoolSize;
    }

    ScheduledThreadPoolExecutor getThreadPool() {
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(this.corePoolSize, new ThreadFactory(){
            private final AtomicInteger value = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(null, r, ScheduledThreadPoolSupplier.this.threadNamePrefix + this.value.incrementAndGet());
                t.setDaemon(ScheduledThreadPoolSupplier.this.isDaemon);
                return t;
            }
        });
        if (this.prestart) {
            result.prestartAllCoreThreads();
        }
        ObserverManager.registerExecutorService(this, result);
        return result;
    }

    @Override
    public ScheduledExecutorService get() {
        return (ScheduledExecutorService)this.lazyValue.get();
    }
}

