/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.sysfiles.domain.throttling;

import com.google.common.base.MoreObjects;
import com.hedera.node.app.hapi.utils.sysfiles.ParsingUtils;

public record ScaleFactor(int numerator, int denominator) implements Comparable<ScaleFactor>
{
    public static final ScaleFactor ONE_TO_ONE = new ScaleFactor(1, 1);

    public static ScaleFactor from(String literal) {
        return ParsingUtils.fromTwoPartDelimited(literal, ":", (n, d) -> {
            if (n < 0 || d < 0) {
                throw new IllegalArgumentException("Negative number in scale literal '" + literal + "'");
            }
            if (d == 0) {
                throw new IllegalArgumentException("Division by zero in scale literal '" + literal + "'");
            }
        }, Integer::parseInt, Integer::parseInt, ScaleFactor::new);
    }

    public int scaling(int nominalOps) {
        int maxUnscaledOps = Integer.MAX_VALUE / this.numerator;
        if (nominalOps > maxUnscaledOps) {
            return Integer.MAX_VALUE / this.denominator;
        }
        return Math.max(1, nominalOps * this.numerator / this.denominator);
    }

    public int asApproxCapacitySplit() {
        return (this.denominator + this.numerator - 1) / this.numerator;
    }

    @Override
    public int compareTo(ScaleFactor that) {
        return Integer.compare(this.numerator * that.denominator, that.numerator * this.denominator);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ScaleFactor.class).add("scale", (Object)(this.numerator + ":" + this.denominator)).toString();
    }

    @Override
    public int hashCode() {
        int result = Integer.hashCode(this.numerator);
        return 31 * result + Integer.hashCode(this.denominator);
    }
}

