/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.validation;

import com.hedera.node.config.types.KeyValuePair;
import com.hedera.node.config.validation.EmulatesMap;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.validation.ConfigValidator;
import com.swirlds.config.api.validation.ConfigViolation;
import com.swirlds.config.extensions.reflection.ConfigReflectionUtils;
import com.swirlds.config.extensions.validators.DefaultConfigViolation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class EmulatesMapValidator
implements ConfigValidator {
    @NonNull
    public Stream<ConfigViolation> validate(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration, "Configuration cannot be null");
        return ConfigReflectionUtils.getAllMatchingPropertiesForConstraintAnnotation(EmulatesMap.class, (Configuration)configuration).stream().map(this::convert).filter(Optional::isPresent).map(Optional::get);
    }

    @NonNull
    private Optional<ConfigViolation> convert(@NonNull ConfigReflectionUtils.AnnotatedProperty<EmulatesMap, ?> property) {
        Objects.requireNonNull(property, "property cannot be null");
        Class type = property.propertyType();
        if (!List.class.isAssignableFrom(type) && !Set.class.isAssignableFrom(type)) {
            ConfigViolation violation = this.create(property, "Property is annotated with @EmulatesMap but is not a Set or List");
            return Optional.of(violation);
        }
        Type genericType = property.component().getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type singleGenericTypeArgument = ConfigReflectionUtils.getSingleGenericTypeArgument((ParameterizedType)parameterizedType);
            if (!KeyValuePair.class.equals((Object)singleGenericTypeArgument)) {
                ConfigViolation violation = this.create(property, "Property is annotated with @EmulatesMap but is not a Collection of KeyValuePair");
                return Optional.of(violation);
            }
        } else {
            ConfigViolation violation = this.create(property, "Property is annotated with @EmulatesMap but is not a Collection of KeyValuePair");
            return Optional.of(violation);
        }
        ConfigReflectionUtils.AnnotatedProperty<EmulatesMap, ?> typedValue = property;
        long uniqueKeyCount = ((Collection)typedValue.propertyValue()).stream().map(p -> p.key()).distinct().count();
        if (uniqueKeyCount != (long)((Collection)typedValue.propertyValue()).size()) {
            ConfigViolation violation = this.create(typedValue, "Property contains duplicate keys");
            return Optional.of(violation);
        }
        return Optional.empty();
    }

    @NonNull
    private ConfigViolation create(@NonNull ConfigReflectionUtils.AnnotatedProperty<EmulatesMap, ?> property, @NonNull String message) {
        Objects.requireNonNull(property, "AnnotatedProperty cannot be null");
        Objects.requireNonNull(message, "Message cannot be null");
        return new DefaultConfigViolation(property.propertyName(), "VALUE_NOT_AVAILABLE", true, message);
    }
}

