/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import java.nio.ByteOrder;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;

public interface UInt256Value<T extends UInt256Value<T>>
extends Bytes32 {
    public T add(T var1);

    default public T plus(T value) {
        return this.add(value);
    }

    default public T plus(long value) {
        return this.add(value);
    }

    default public T addExact(T value) {
        T result = this.add(value);
        if (this.compareTo((Bytes)result) > 0) {
            throw new ArithmeticException("UInt256 overflow");
        }
        return result;
    }

    default public T addSafe(T value) {
        T result = this.add(value);
        if (this.compareTo((Bytes)result) > 0) {
            return this.max();
        }
        return result;
    }

    public T add(long var1);

    default public T addExact(long value) {
        T result = this.add(value);
        if (value > 0L && this.compareTo((Bytes)result) > 0 || value < 0L && this.compareTo((Bytes)result) < 0) {
            throw new ArithmeticException("UInt256 overflow");
        }
        return result;
    }

    default public T addSafe(long value) {
        T result = this.add(value);
        if (value > 0L && this.compareTo((Bytes)result) > 0 || value < 0L && this.compareTo((Bytes)result) < 0) {
            return this.max();
        }
        return result;
    }

    public T addMod(T var1, UInt256 var2);

    public T addMod(long var1, UInt256 var3);

    public T addMod(long var1, long var3);

    public T subtract(T var1);

    default public T subtractExact(T value) {
        T result = this.subtract(value);
        if (this.compareTo((Bytes)result) < 0) {
            throw new ArithmeticException("UInt256 overflow");
        }
        return result;
    }

    public T subtract(long var1);

    default public T subtractExact(long value) {
        T result = this.subtract(value);
        if (value > 0L && this.compareTo((Bytes)result) < 0 || value < 0L && this.compareTo((Bytes)result) > 0) {
            throw new ArithmeticException("UInt256 overflow");
        }
        return result;
    }

    public T max();

    public T multiply(T var1);

    public T multiply(long var1);

    public T multiplyMod(T var1, UInt256 var2);

    public T multiplyMod(long var1, UInt256 var3);

    public T multiplyMod(long var1, long var3);

    public T divide(T var1);

    public T divide(long var1);

    public T divideCeil(T var1);

    public T divideCeil(long var1);

    public T pow(UInt256 var1);

    public T pow(long var1);

    public T mod(UInt256 var1);

    public T mod(long var1);

    public T mod0(UInt256 var1);

    public T mod0(long var1);

    default public boolean fitsInt() {
        return this.fitsInt(ByteOrder.BIG_ENDIAN);
    }

    default public boolean fitsInt(ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < 28; ++i) {
                if (this.get(i) == 0) continue;
                return false;
            }
            return this.get(28) >= 0;
        }
        for (int i = 4; i < 28; ++i) {
            if (this.get(i) == 0) continue;
            return false;
        }
        return this.get(3) >= 0;
    }

    default public int intValue() {
        if (!this.fitsInt()) {
            throw new ArithmeticException("Value does not fit a 4 byte int");
        }
        return this.getInt(28);
    }

    default public int toInt(ByteOrder order) {
        if (!this.fitsInt(order)) {
            throw new ArithmeticException("Value does not fit a 4 byte int");
        }
        if (order == ByteOrder.BIG_ENDIAN) {
            return this.getInt(28, order);
        }
        return this.getInt(0, order);
    }

    default public long toLong(ByteOrder order) {
        if (!this.fitsLong(order)) {
            throw new ArithmeticException("Value does not fit a 8 byte long");
        }
        if (order == ByteOrder.BIG_ENDIAN) {
            return this.getLong(24, order);
        }
        return this.getLong(0, order);
    }

    default public boolean fitsLong() {
        return this.fitsLong(ByteOrder.BIG_ENDIAN);
    }

    default public boolean fitsLong(ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < 24; ++i) {
                if (this.get(i) == 0) continue;
                return false;
            }
            return this.get(24) >= 0;
        }
        for (int i = 8; i < 32; ++i) {
            if (this.get(i) == 0) continue;
            return false;
        }
        return this.get(7) >= 0;
    }

    public UInt256 toUInt256();

    public Bytes32 toBytes();

    public Bytes toMinimalBytes();

    default public boolean greaterThan(UInt256Value<T> other) {
        return this.compareTo((Bytes)other) > 0;
    }

    default public boolean greaterOrEqualThan(UInt256Value<T> other) {
        return this.compareTo((Bytes)other) >= 0;
    }

    default public boolean lessThan(UInt256Value<T> other) {
        return this.compareTo((Bytes)other) < 0;
    }

    default public boolean lessOrEqualThan(UInt256Value<T> other) {
        return this.compareTo((Bytes)other) <= 0;
    }

    default public String toDecimalString() {
        return this.toBigInteger().toString(10);
    }

    default public BigInteger toSignedBigInteger() {
        return this.toSignedBigInteger(ByteOrder.BIG_ENDIAN);
    }

    default public BigInteger toSignedBigInteger(ByteOrder order) {
        if (this.size() == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(order == ByteOrder.BIG_ENDIAN ? this.toArrayUnsafe() : this.reverse().toArrayUnsafe());
    }

    default public BigInteger toBigInteger() {
        return this.toUnsignedBigInteger();
    }

    default public BigInteger toBigInteger(ByteOrder order) {
        return this.toUnsignedBigInteger(order);
    }
}

