/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.nativelib.gnark;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;

public class LibGnarkEIP196 {
    public static final int EIP196_PREALLOCATE_FOR_RESULT_BYTES = 128;
    public static final int EIP196_PREALLOCATE_FOR_ERROR_BYTES = 256;
    public static final byte EIP196_ADD_OPERATION_RAW_VALUE = 1;
    public static final byte EIP196_MUL_OPERATION_RAW_VALUE = 2;
    public static final byte EIP196_PAIR_OPERATION_RAW_VALUE = 3;
    public static final boolean ENABLED;

    public static int eip196_perform_operation(byte op, byte[] i, int i_len, byte[] output, IntByReference o_len, byte[] err, IntByReference err_len) {
        int ret = -1;
        switch (op) {
            case 1: {
                ret = LibGnarkEIP196.eip196altbn128G1Add(i, output, err, i_len, o_len, err_len);
                break;
            }
            case 2: {
                ret = LibGnarkEIP196.eip196altbn128G1Mul(i, output, err, i_len, o_len, err_len);
                break;
            }
            case 3: {
                ret = LibGnarkEIP196.eip196altbn128Pairing(i, output, err, i_len, o_len, err_len);
                break;
            }
            default: {
                throw new RuntimeException("Not Implemented EIP-196 operation " + op);
            }
        }
        return ret;
    }

    public static native int eip196altbn128G1Add(byte[] var0, byte[] var1, byte[] var2, int var3, IntByReference var4, IntByReference var5);

    public static native int eip196altbn128G1Mul(byte[] var0, byte[] var1, byte[] var2, int var3, IntByReference var4, IntByReference var5);

    public static native int eip196altbn128Pairing(byte[] var0, byte[] var1, byte[] var2, int var3, IntByReference var4, IntByReference var5);

    static {
        boolean enabled;
        try {
            Native.register(LibGnarkEIP196.class, (String)"gnark_eip_196");
            enabled = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            enabled = false;
        }
        ENABLED = enabled;
    }
}

