/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.Bytes;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.LazyString;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.WritableHeaders;
import java.nio.charset.StandardCharsets;

public final class Http1HeadersParser {
    private static final byte[] HD_HOST = (HeaderNameEnum.HOST.defaultCase() + ":").getBytes(StandardCharsets.UTF_8);
    private static final byte[] HD_ACCEPT = (HeaderNameEnum.ACCEPT.defaultCase() + ":").getBytes(StandardCharsets.UTF_8);
    private static final byte[] HD_CONNECTION = (HeaderNameEnum.CONNECTION.defaultCase() + ":").getBytes(StandardCharsets.UTF_8);
    private static final byte[] HD_USER_AGENT = (HeaderNameEnum.USER_AGENT.defaultCase() + ":").getBytes(StandardCharsets.UTF_8);
    private static final long CLOSE_WORD = 111546465018656L;
    private static final long KEEP_ALIVE_WORD_1 = 7809573189597883168L;
    private static final long KEEP_ALIVE_WORD_2 = 6649449L;

    private Http1HeadersParser() {
    }

    public static WritableHeaders<?> readHeaders(DataReader reader, int maxHeadersSize, boolean validate) {
        WritableHeaders<?> headers = WritableHeaders.create();
        int maxLength = maxHeadersSize;
        do {
            Header headerValue;
            HeaderName header;
            int eol;
            if (reader.startsWithNewLine()) {
                reader.skip(2);
                return headers;
            }
            if ((eol = reader.findNewLine(maxLength -= (header = Http1HeadersParser.readHeaderName(reader, maxLength)).defaultCase().length() + 2)) == maxLength) {
                throw new IllegalStateException("Header size exceeded");
            }
            if (header.equals(HeaderNames.CONNECTION)) {
                headerValue = Http1HeadersParser.connectionHeaderValue(reader, eol);
            } else {
                LazyString value = reader.readLazyString(StandardCharsets.US_ASCII, eol);
                headerValue = HeaderValues.create(header, value);
            }
            reader.skip(2);
            maxLength -= eol + 1;
            headers.add(headerValue);
            if (!validate) continue;
            headerValue.validate();
        } while (maxLength >= 0);
        throw new IllegalStateException("Header size exceeded");
    }

    private static Header connectionHeaderValue(DataReader reader, int eol) {
        byte[] bytes = reader.readBytes(eol);
        if (bytes.length == 11 && Http1HeadersParser.isKeepAlive(bytes)) {
            return HeaderValues.CONNECTION_KEEP_ALIVE;
        }
        if (bytes.length == 6 && Http1HeadersParser.isClose(bytes)) {
            return HeaderValues.CONNECTION_CLOSE;
        }
        return HeaderValues.create(HeaderNames.CONNECTION, new LazyString(bytes, 0, bytes.length, StandardCharsets.US_ASCII));
    }

    private static boolean isKeepAlive(byte[] buffer) {
        if (Bytes.toWord((byte[])buffer, (int)0) != 7809573189597883168L) {
            return false;
        }
        long endWord = buffer[8] & 0xFF | (buffer[9] & 0xFF) << 8 | (buffer[10] & 0xFF) << 16;
        return endWord == 6649449L;
    }

    private static boolean isClose(byte[] buffer) {
        long word = (long)(buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16) | ((long)buffer[3] & 0xFFL) << 24 | ((long)buffer[4] & 0xFFL) << 32 | ((long)buffer[5] & 0xFFL) << 40;
        return word == 111546465018656L;
    }

    private static HeaderName readHeaderName(DataReader reader, int maxLength) {
        switch (reader.lookup()) {
            case 72: {
                if (!reader.startsWith(HD_HOST)) break;
                reader.skip(HD_HOST.length);
                return HeaderNameEnum.HOST;
            }
            case 65: {
                if (!reader.startsWith(HD_ACCEPT)) break;
                reader.skip(HD_ACCEPT.length);
                return HeaderNameEnum.ACCEPT;
            }
            case 67: {
                if (!reader.startsWith(HD_CONNECTION)) break;
                reader.skip(HD_CONNECTION.length);
                return HeaderNameEnum.CONNECTION;
            }
            case 85: {
                if (!reader.startsWith(HD_USER_AGENT)) break;
                reader.skip(HD_USER_AGENT.length);
                return HeaderNameEnum.USER_AGENT;
            }
        }
        int col = reader.findOrNewLine((byte)58, maxLength);
        if (col == maxLength) {
            throw new IllegalStateException("Header size exceeded");
        }
        if (col < 0) {
            throw new IllegalArgumentException("Invalid header, missing colon:\n" + reader.debugDataHex());
        }
        String headerName = reader.readAsciiString(col);
        HeaderName header = HeaderNames.create(headerName);
        reader.skip(1);
        return header;
    }
}

