/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.Ascii;
import io.helidon.http.HttpToken;
import io.helidon.http.MethodHelper;
import io.helidon.http.MethodPredicate;
import io.helidon.http.MethodPredicates;
import java.util.Collection;
import java.util.Objects;

public final class Method {
    private static final String GET_STRING = "GET";
    public static final Method GET = new Method("GET", true);
    public static final Method POST = new Method("POST", true);
    public static final Method PUT = new Method("PUT", true);
    public static final Method DELETE = new Method("DELETE", true);
    public static final Method HEAD = new Method("HEAD", true);
    public static final Method OPTIONS = new Method("OPTIONS", true);
    public static final Method TRACE = new Method("TRACE", true);
    public static final Method PATCH = new Method("PATCH", true);
    public static final Method CONNECT = new Method("CONNECT", true);
    private final String name;
    private final int length;
    private final boolean instance;

    private Method(String name, boolean instance) {
        this.name = name;
        this.length = name.length();
        this.instance = instance;
        if (instance) {
            MethodHelper.add(this);
        }
    }

    public static Method create(String name) {
        if (name.equals(GET_STRING)) {
            return GET;
        }
        String methodName = Ascii.toUpperCase((String)name);
        Method method = MethodHelper.byName(methodName);
        if (method == null) {
            HttpToken.validate(methodName);
            return new Method(methodName, false);
        }
        return method;
    }

    public static MethodPredicate predicate(Method ... methods) {
        return switch (methods.length) {
            case 0 -> MethodPredicates.TruePredicate.get();
            case 1 -> {
                if (methods[0].instance) {
                    yield new MethodPredicates.SingleMethodEnumPredicate(methods[0]);
                }
                yield new MethodPredicates.SingleMethodPredicate(methods[0]);
            }
            default -> new MethodPredicates.MethodsPredicate(methods);
        };
    }

    public static MethodPredicate predicate(Collection<Method> methods) {
        switch (methods.size()) {
            case 0: {
                return MethodPredicates.TruePredicate.get();
            }
            case 1: {
                Method first = methods.iterator().next();
                return first.instance ? new MethodPredicates.SingleMethodEnumPredicate(first) : new MethodPredicates.SingleMethodPredicate(first);
            }
        }
        return new MethodPredicates.MethodsPredicate(methods.toArray(new Method[0]));
    }

    @Deprecated
    public String name() {
        return this.text();
    }

    public String text() {
        return this.name;
    }

    public int length() {
        return this.length;
    }

    public String toString() {
        return this.text();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Method method = (Method)o;
        return this.name.equals(method.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    static {
        MethodHelper.methodsDone();
    }
}

