/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.client.helidon;

import io.helidon.common.buffers.BufferData;
import java.nio.BufferOverflowException;

class PbjGrpcDatagramReader {
    static final int PREFIX_LENGTH = 5;
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private static final int MAX_BUFFER_SIZE = 0xA00000;
    private byte[] buffer = new byte[1024];
    private int readPosition = 0;
    private int writePosition = 0;
    private int length = 0;

    PbjGrpcDatagramReader() {
    }

    void add(BufferData bufferData) {
        this.ensureCapacity(bufferData.available());
        int firstPartMaxLengthForWriting = this.buffer.length - this.writePosition;
        int read = bufferData.read(this.buffer, this.writePosition, Math.min(bufferData.available(), firstPartMaxLengthForWriting));
        if (bufferData.available() > 0) {
            read += bufferData.read(this.buffer, 0, bufferData.available());
        }
        this.length += read;
        this.writePosition += read;
        this.writePosition %= this.buffer.length;
    }

    private int getNextSize() {
        if (this.length < 5) {
            return -1;
        }
        int size = Byte.toUnsignedInt(this.buffer[(this.readPosition + 1) % this.buffer.length]) << 24 | Byte.toUnsignedInt(this.buffer[(this.readPosition + 2) % this.buffer.length]) << 16 | Byte.toUnsignedInt(this.buffer[(this.readPosition + 3) % this.buffer.length]) << 8 | Byte.toUnsignedInt(this.buffer[(this.readPosition + 4) % this.buffer.length]);
        if (this.length < 5 + size) {
            return -1;
        }
        return size;
    }

    BufferData extractNextDatagram() {
        int size = this.getNextSize();
        if (size == -1) {
            return null;
        }
        BufferData data = BufferData.create((int)size);
        this.readPosition += 5;
        this.readPosition %= this.buffer.length;
        int firstPartMaxLengthForReading = this.buffer.length - this.readPosition;
        data.write(this.buffer, this.readPosition, Math.min(firstPartMaxLengthForReading, size));
        if (size > firstPartMaxLengthForReading) {
            data.write(this.buffer, 0, size - firstPartMaxLengthForReading);
        }
        this.readPosition += size;
        this.readPosition %= this.buffer.length;
        this.length -= 5 + size;
        return data;
    }

    private void ensureCapacity(int minCapacity) {
        int currentCapacity = this.buffer.length - this.length;
        if (currentCapacity >= minCapacity) {
            return;
        }
        int newLength = this.buffer.length + (minCapacity - currentCapacity);
        if (newLength > 0xA00000) {
            throw new BufferOverflowException();
        }
        int actualNewLength = Math.min(Math.max(this.buffer.length * 2, newLength), 0xA00000);
        byte[] newBuffer = new byte[actualNewLength];
        if (this.length > 0) {
            int firstPartMaxLength = this.buffer.length - this.readPosition;
            System.arraycopy(this.buffer, this.readPosition, newBuffer, 0, Math.min(this.length, firstPartMaxLength));
            if (firstPartMaxLength < this.length) {
                System.arraycopy(this.buffer, 0, newBuffer, firstPartMaxLength, this.length - firstPartMaxLength);
            }
        }
        this.buffer = newBuffer;
        this.readPosition = 0;
        this.writePosition = this.length;
    }
}

