/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.fluent;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.InlineMe;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.collections.trie.BytesTrieSet;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.VersionedHash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.MainnetEVMs;
import org.hyperledger.besu.evm.blockhash.BlockHashLookup;
import org.hyperledger.besu.evm.code.CodeV0;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.contractvalidation.MaxCodeSizeRule;
import org.hyperledger.besu.evm.contractvalidation.PrefixCodeRule;
import org.hyperledger.besu.evm.fluent.SimpleBlockValues;
import org.hyperledger.besu.evm.fluent.SimpleWorld;
import org.hyperledger.besu.evm.frame.BlockValues;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.precompile.MainnetPrecompiledContracts;
import org.hyperledger.besu.evm.precompile.PrecompileContractRegistry;
import org.hyperledger.besu.evm.processor.ContractCreationProcessor;
import org.hyperledger.besu.evm.processor.MessageCallProcessor;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class EVMExecutor {
    private final EVM evm;
    private PrecompileContractRegistry precompileContractRegistry;
    private boolean commitWorldState = false;
    private WorldUpdater worldUpdater = new SimpleWorld();
    private long gas = Long.MAX_VALUE;
    private Address receiver = Address.ZERO;
    private Address sender = Address.ZERO;
    private Address contract = Address.ZERO;
    private Address coinbase = Address.ZERO;
    private Wei gasPriceGWei = Wei.ZERO;
    private Wei blobGasPrice = Wei.ZERO;
    private Bytes callData = Bytes.EMPTY;
    private Wei ethValue = Wei.ZERO;
    private Code code = CodeV0.EMPTY_CODE;
    private BlockValues blockValues = new SimpleBlockValues();
    private BlockHashLookup blockHashLookup = (__, ___) -> null;
    private Optional<List<VersionedHash>> versionedHashes = Optional.empty();
    private OperationTracer tracer = OperationTracer.NO_TRACING;
    private boolean requireDeposit = true;
    private List<ContractValidationRule> contractValidationRules = List.of(MaxCodeSizeRule.from(EvmSpecVersion.SPURIOUS_DRAGON, EvmConfiguration.DEFAULT), PrefixCodeRule.of());
    private long initialNonce = 1L;
    private Collection<Address> forceCommitAddresses = List.of(Address.fromHexString((String)"0x03"));
    private Set<Address> accessListWarmAddresses = new BytesTrieSet<Address>(20);
    private Multimap<Address, Bytes32> accessListWarmStorage = HashMultimap.create();
    private MessageCallProcessor messageCallProcessor = null;
    private ContractCreationProcessor contractCreationProcessor = null;
    private MessageFrame.Type messageFrameType = MessageFrame.Type.MESSAGE_CALL;

    private EVMExecutor(EVM evm) {
        Preconditions.checkNotNull((Object)evm, (Object)"evm must not be null");
        this.evm = evm;
    }

    public static EVMExecutor evm() {
        return EVMExecutor.evm(EvmSpecVersion.mostRecent());
    }

    public static EVMExecutor evm(EvmSpecVersion fork) {
        return EVMExecutor.evm(fork, BigInteger.ONE);
    }

    public static EVMExecutor evm(EvmSpecVersion fork, BigInteger chainId) {
        return EVMExecutor.evm(fork, chainId, EvmConfiguration.DEFAULT);
    }

    public static EVMExecutor evm(EvmSpecVersion fork, Bytes chainId) {
        return EVMExecutor.evm(fork, new BigInteger(1, chainId.toArrayUnsafe()), EvmConfiguration.DEFAULT);
    }

    public static EVMExecutor evm(EvmSpecVersion fork, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return switch (fork) {
            default -> throw new MatchException(null, null);
            case EvmSpecVersion.FRONTIER -> EVMExecutor.frontier(evmConfiguration);
            case EvmSpecVersion.HOMESTEAD -> EVMExecutor.homestead(evmConfiguration);
            case EvmSpecVersion.TANGERINE_WHISTLE -> EVMExecutor.tangerineWhistle(evmConfiguration);
            case EvmSpecVersion.SPURIOUS_DRAGON -> EVMExecutor.spuriousDragon(evmConfiguration);
            case EvmSpecVersion.BYZANTIUM -> EVMExecutor.byzantium(evmConfiguration);
            case EvmSpecVersion.CONSTANTINOPLE -> EVMExecutor.constantinople(evmConfiguration);
            case EvmSpecVersion.PETERSBURG -> EVMExecutor.petersburg(evmConfiguration);
            case EvmSpecVersion.ISTANBUL -> EVMExecutor.istanbul(chainId, evmConfiguration);
            case EvmSpecVersion.BERLIN -> EVMExecutor.berlin(chainId, evmConfiguration);
            case EvmSpecVersion.LONDON -> EVMExecutor.london(chainId, evmConfiguration);
            case EvmSpecVersion.PARIS -> EVMExecutor.paris(chainId, evmConfiguration);
            case EvmSpecVersion.SHANGHAI -> EVMExecutor.shanghai(chainId, evmConfiguration);
            case EvmSpecVersion.CANCUN -> EVMExecutor.cancun(chainId, evmConfiguration);
            case EvmSpecVersion.CANCUN_EOF -> EVMExecutor.cancunEOF(chainId, evmConfiguration);
            case EvmSpecVersion.PRAGUE -> EVMExecutor.prague(chainId, evmConfiguration);
            case EvmSpecVersion.OSAKA -> EVMExecutor.osaka(chainId, evmConfiguration);
            case EvmSpecVersion.AMSTERDAM -> EVMExecutor.amsterdam(chainId, evmConfiguration);
            case EvmSpecVersion.BOGOTA -> EVMExecutor.bogota(chainId, evmConfiguration);
            case EvmSpecVersion.POLIS -> EVMExecutor.polis(chainId, evmConfiguration);
            case EvmSpecVersion.BANGKOK -> EVMExecutor.bangkok(chainId, evmConfiguration);
            case EvmSpecVersion.FUTURE_EIPS -> EVMExecutor.futureEips(chainId, evmConfiguration);
            case EvmSpecVersion.EXPERIMENTAL_EIPS -> EVMExecutor.experimentalEips(chainId, evmConfiguration);
        };
    }

    public static EVMExecutor evm(EVM evm) {
        return new EVMExecutor(evm);
    }

    public static EVMExecutor frontier(EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.frontier(evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.frontier(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of();
        executor.requireDeposit = false;
        executor.forceCommitAddresses = List.of();
        executor.initialNonce = 0L;
        return executor;
    }

    public static EVMExecutor homestead(EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.homestead(evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.frontier(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of();
        executor.forceCommitAddresses = List.of();
        executor.initialNonce = 0L;
        return executor;
    }

    public static EVMExecutor tangerineWhistle(EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.tangerineWhistle(evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.frontier(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of();
        executor.initialNonce = 0L;
        return executor;
    }

    public static EVMExecutor spuriousDragon(EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.spuriousDragon(evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.frontier(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of(MaxCodeSizeRule.from(executor.evm));
        return executor;
    }

    public static EVMExecutor byzantium(EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.byzantium(evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.byzantium(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of(MaxCodeSizeRule.from(executor.evm));
        return executor;
    }

    public static EVMExecutor constantinople(EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.constantinople(evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.byzantium(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of(MaxCodeSizeRule.from(executor.evm));
        return executor;
    }

    public static EVMExecutor petersburg(EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.petersburg(evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.byzantium(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of(MaxCodeSizeRule.from(executor.evm));
        return executor;
    }

    @Deprecated(forRemoval=true)
    @InlineMe(replacement="EVMExecutor.evm(EvmSpecVersion.ISTANBUL, BigInteger.ONE, evmConfiguration)", imports={"java.math.BigInteger", "org.hyperledger.besu.evm.EvmSpecVersion", "org.hyperledger.besu.evm.fluent.EVMExecutor"})
    public static EVMExecutor istanbul(EvmConfiguration evmConfiguration) {
        return EVMExecutor.evm(EvmSpecVersion.ISTANBUL, BigInteger.ONE, evmConfiguration);
    }

    public static EVMExecutor istanbul(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.istanbul(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.istanbul(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of(MaxCodeSizeRule.from(executor.evm));
        return executor;
    }

    @Deprecated(forRemoval=true)
    @InlineMe(replacement="EVMExecutor.evm(EvmSpecVersion.BERLIN, BigInteger.ONE, evmConfiguration)", imports={"java.math.BigInteger", "org.hyperledger.besu.evm.EvmSpecVersion", "org.hyperledger.besu.evm.fluent.EVMExecutor"})
    public static EVMExecutor berlin(EvmConfiguration evmConfiguration) {
        return EVMExecutor.evm(EvmSpecVersion.BERLIN, BigInteger.ONE, evmConfiguration);
    }

    public static EVMExecutor berlin(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.berlin(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.istanbul(executor.evm.getGasCalculator());
        executor.contractValidationRules = List.of(MaxCodeSizeRule.from(executor.evm));
        return executor;
    }

    @Deprecated(forRemoval=true)
    @InlineMe(replacement="EVMExecutor.evm(EvmSpecVersion.LONDON, BigInteger.ONE, evmConfiguration)", imports={"java.math.BigInteger", "org.hyperledger.besu.evm.EvmSpecVersion", "org.hyperledger.besu.evm.fluent.EVMExecutor"})
    public static EVMExecutor london(EvmConfiguration evmConfiguration) {
        return EVMExecutor.evm(EvmSpecVersion.LONDON, BigInteger.ONE, evmConfiguration);
    }

    public static EVMExecutor london(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.london(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.istanbul(executor.evm.getGasCalculator());
        return executor;
    }

    @Deprecated(forRemoval=true)
    @InlineMe(replacement="EVMExecutor.evm(EvmSpecVersion.PARIS, BigInteger.ONE, evmConfiguration)", imports={"java.math.BigInteger", "org.hyperledger.besu.evm.EvmSpecVersion", "org.hyperledger.besu.evm.fluent.EVMExecutor"})
    public static EVMExecutor paris(EvmConfiguration evmConfiguration) {
        return EVMExecutor.evm(EvmSpecVersion.PARIS, BigInteger.ONE, evmConfiguration);
    }

    public static EVMExecutor paris(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.paris(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.istanbul(executor.evm.getGasCalculator());
        return executor;
    }

    @Deprecated(forRemoval=true)
    @InlineMe(replacement="EVMExecutor.evm(EvmSpecVersion.SHANGHAI, BigInteger.ONE, evmConfiguration)", imports={"java.math.BigInteger", "org.hyperledger.besu.evm.EvmSpecVersion", "org.hyperledger.besu.evm.fluent.EVMExecutor"})
    public static EVMExecutor shanghai(EvmConfiguration evmConfiguration) {
        return EVMExecutor.evm(EvmSpecVersion.SHANGHAI, BigInteger.ONE, evmConfiguration);
    }

    public static EVMExecutor shanghai(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.shanghai(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.istanbul(executor.evm.getGasCalculator());
        return executor;
    }

    @Deprecated(forRemoval=true)
    @InlineMe(replacement="EVMExecutor.evm(EvmSpecVersion.CANCUN, BigInteger.ONE, evmConfiguration)", imports={"java.math.BigInteger", "org.hyperledger.besu.evm.EvmSpecVersion", "org.hyperledger.besu.evm.fluent.EVMExecutor"})
    public static EVMExecutor cancun(EvmConfiguration evmConfiguration) {
        return EVMExecutor.evm(EvmSpecVersion.CANCUN, BigInteger.ONE, evmConfiguration);
    }

    public static EVMExecutor cancun(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.cancun(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.cancun(executor.evm.getGasCalculator());
        return executor;
    }

    public static EVMExecutor cancunEOF(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.cancunEOF(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.cancun(executor.evm.getGasCalculator());
        return executor;
    }

    public static EVMExecutor prague(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.prague(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.prague(executor.evm.getGasCalculator());
        return executor;
    }

    public static EVMExecutor osaka(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.osaka(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.prague(executor.evm.getGasCalculator());
        return executor;
    }

    public static EVMExecutor amsterdam(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.amsterdam(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.prague(executor.evm.getGasCalculator());
        return executor;
    }

    public static EVMExecutor bogota(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.bogota(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.prague(executor.evm.getGasCalculator());
        return executor;
    }

    public static EVMExecutor polis(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.polis(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.prague(executor.evm.getGasCalculator());
        return executor;
    }

    public static EVMExecutor bangkok(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.bangkok(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.prague(executor.evm.getGasCalculator());
        return executor;
    }

    @Deprecated(forRemoval=true)
    @InlineMe(replacement="EVMExecutor.evm(EvmSpecVersion.FUTURE_EIPS, BigInteger.ONE, evmConfiguration)", imports={"java.math.BigInteger", "org.hyperledger.besu.evm.EvmSpecVersion", "org.hyperledger.besu.evm.fluent.EVMExecutor"})
    public static EVMExecutor futureEips(EvmConfiguration evmConfiguration) {
        return EVMExecutor.evm(EvmSpecVersion.FUTURE_EIPS, BigInteger.ONE, evmConfiguration);
    }

    public static EVMExecutor futureEips(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.futureEips(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.futureEIPs(executor.evm.getGasCalculator());
        return executor;
    }

    public static EVMExecutor experimentalEips(BigInteger chainId, EvmConfiguration evmConfiguration) {
        EVMExecutor executor = new EVMExecutor(MainnetEVMs.experimentalEips(chainId, evmConfiguration));
        executor.precompileContractRegistry = MainnetPrecompiledContracts.futureEIPs(executor.evm.getGasCalculator());
        return executor;
    }

    private MessageCallProcessor thisMessageCallProcessor() {
        return Objects.requireNonNullElseGet(this.messageCallProcessor, () -> new MessageCallProcessor(this.evm, this.precompileContractRegistry));
    }

    private ContractCreationProcessor thisContractCreationProcessor() {
        return Objects.requireNonNullElseGet(this.contractCreationProcessor, () -> new ContractCreationProcessor(this.evm, this.requireDeposit, this.contractValidationRules, this.initialNonce, this.forceCommitAddresses));
    }

    public Bytes execute(Code code, Bytes inputData, Wei value, Address receiver) {
        this.code = code;
        this.callData = inputData;
        this.ethValue = value;
        this.receiver = receiver;
        return this.execute();
    }

    public Bytes execute(Bytes codeBytes, Bytes inputData, Wei value, Address receiver) {
        this.code = this.evm.getCode(Hash.hash((Bytes)codeBytes), codeBytes);
        this.callData = inputData;
        this.ethValue = value;
        this.receiver = receiver;
        return this.execute();
    }

    public Bytes execute() {
        MessageCallProcessor mcp = this.thisMessageCallProcessor();
        ContractCreationProcessor ccp = this.thisContractCreationProcessor();
        MessageFrame initialMessageFrame = MessageFrame.builder().type(this.messageFrameType).worldUpdater(this.worldUpdater.updater()).initialGas(this.gas).contract(this.contract).address(this.receiver).originator(this.sender).sender(this.sender).gasPrice(this.gasPriceGWei).blobGasPrice(this.blobGasPrice).inputData(this.callData).value(this.ethValue).apparentValue(this.ethValue).code(this.code).blockValues(this.blockValues).miningBeneficiary(this.coinbase).blockHashLookup(this.blockHashLookup).accessListWarmAddresses(this.accessListWarmAddresses).accessListWarmStorage(this.accessListWarmStorage).versionedHashes(this.versionedHashes).completer(c -> {}).build();
        Deque<MessageFrame> messageFrameStack = initialMessageFrame.getMessageFrameStack();
        while (!messageFrameStack.isEmpty()) {
            MessageFrame messageFrame = messageFrameStack.peek();
            (switch (messageFrame.getType()) {
                default -> throw new MatchException(null, null);
                case MessageFrame.Type.CONTRACT_CREATION -> ccp;
                case MessageFrame.Type.MESSAGE_CALL -> mcp;
            }).process(messageFrame, this.tracer);
        }
        initialMessageFrame.getSelfDestructs().forEach(this.worldUpdater::deleteAccount);
        if (this.commitWorldState) {
            this.worldUpdater.commit();
        }
        return initialMessageFrame.getReturnData();
    }

    public EVMExecutor commitWorldState() {
        return this.commitWorldState(true);
    }

    public EVMExecutor commitWorldState(boolean commitWorldState) {
        this.commitWorldState = commitWorldState;
        return this;
    }

    public EVMExecutor worldUpdater(WorldUpdater worldUpdater) {
        this.worldUpdater = worldUpdater;
        return this;
    }

    public EVMExecutor gas(long gas) {
        this.gas = gas;
        return this;
    }

    public EVMExecutor receiver(Address receiver) {
        this.receiver = receiver;
        return this;
    }

    public EVMExecutor sender(Address sender) {
        this.sender = sender;
        return this;
    }

    public EVMExecutor contract(Address contract) {
        this.contract = contract;
        return this;
    }

    public EVMExecutor coinbase(Address coinbase) {
        this.coinbase = coinbase;
        if (EvmSpecVersion.SHANGHAI.compareTo(this.evm.getEvmVersion()) <= 0) {
            this.warmAddress(coinbase);
        }
        return this;
    }

    public EVMExecutor gasPriceGWei(Wei gasPriceGWei) {
        this.gasPriceGWei = gasPriceGWei;
        return this;
    }

    public EVMExecutor blobGasPrice(Wei blobGasPrice) {
        this.blobGasPrice = blobGasPrice;
        return this;
    }

    public EVMExecutor callData(Bytes callData) {
        this.callData = callData;
        return this;
    }

    public EVMExecutor ethValue(Wei ethValue) {
        this.ethValue = ethValue;
        return this;
    }

    public EVMExecutor code(Code code) {
        this.code = code;
        return this;
    }

    public EVMExecutor code(Bytes codeBytes) {
        return this.code(codeBytes, Hash.hash((Bytes)codeBytes));
    }

    public EVMExecutor code(Bytes codeBytes, Hash hash) {
        this.code = this.evm.getCode(hash, codeBytes);
        return this;
    }

    public EVMExecutor blockValues(BlockValues blockValues) {
        this.blockValues = blockValues;
        return this;
    }

    public EVMExecutor difficulty(Bytes difficulty) {
        ((SimpleBlockValues)this.blockValues).setDifficultyBytes(difficulty);
        return this;
    }

    public EVMExecutor mixHash(Bytes32 mixHash) {
        ((SimpleBlockValues)this.blockValues).setMixHashOrPrevRandao(mixHash);
        return this;
    }

    public EVMExecutor prevRandao(Bytes32 prevRandao) {
        ((SimpleBlockValues)this.blockValues).setMixHashOrPrevRandao(prevRandao);
        return this;
    }

    public EVMExecutor baseFee(Wei baseFee) {
        return this.baseFee(Optional.ofNullable(baseFee));
    }

    public EVMExecutor baseFee(Optional<Wei> baseFee) {
        ((SimpleBlockValues)this.blockValues).setBaseFee(baseFee);
        return this;
    }

    public EVMExecutor number(long number) {
        ((SimpleBlockValues)this.blockValues).setNumber(number);
        return this;
    }

    public EVMExecutor timestamp(long timestamp) {
        ((SimpleBlockValues)this.blockValues).setTimestamp(timestamp);
        return this;
    }

    public EVMExecutor gasLimit(long gasLimit) {
        ((SimpleBlockValues)this.blockValues).setGasLimit(gasLimit);
        return this;
    }

    public EVMExecutor blockHashLookup(BlockHashLookup blockHashLookup) {
        this.blockHashLookup = blockHashLookup;
        return this;
    }

    public EVMExecutor versionedHashes(Optional<List<VersionedHash>> versionedHashes) {
        this.versionedHashes = versionedHashes;
        return this;
    }

    public EVMExecutor tracer(OperationTracer tracer) {
        this.tracer = tracer;
        return this;
    }

    public EVMExecutor precompileContractRegistry(PrecompileContractRegistry precompileContractRegistry) {
        this.precompileContractRegistry = precompileContractRegistry;
        return this;
    }

    public EVMExecutor requireDeposit(boolean requireDeposit) {
        this.requireDeposit = requireDeposit;
        return this;
    }

    public EVMExecutor initialNonce(long initialNonce) {
        this.initialNonce = initialNonce;
        return this;
    }

    public EVMExecutor contractValidationRules(List<ContractValidationRule> contractValidationRules) {
        this.contractValidationRules = contractValidationRules;
        return this;
    }

    public EVMExecutor forceCommitAddresses(Collection<Address> forceCommitAddresses) {
        this.forceCommitAddresses = forceCommitAddresses;
        return this;
    }

    public EVMExecutor accessListWarmAddresses(Set<Address> accessListWarmAddresses) {
        this.accessListWarmAddresses = accessListWarmAddresses;
        return this;
    }

    public EVMExecutor warmAddress(Address ... addresses) {
        this.accessListWarmAddresses.addAll(List.of(addresses));
        return this;
    }

    public EVMExecutor accessListWarmStorage(Multimap<Address, Bytes32> accessListWarmStorage) {
        this.accessListWarmStorage = accessListWarmStorage;
        return this;
    }

    public EVMExecutor accessListWarmStorage(Address address, Bytes32 ... slots) {
        this.accessListWarmStorage.putAll((Object)address, List.of(slots));
        return this;
    }

    public EVMExecutor messageCallProcessor(MessageCallProcessor messageCallProcessor) {
        this.messageCallProcessor = messageCallProcessor;
        return this;
    }

    public EVMExecutor contractCallProcessor(ContractCreationProcessor contractCreationProcessor) {
        this.contractCreationProcessor = contractCreationProcessor;
        return this;
    }

    public EVMExecutor messageFrameType(MessageFrame.Type messageFrameType) {
        this.messageFrameType = messageFrameType;
        return this;
    }

    public EvmSpecVersion getEVMVersion() {
        return this.evm.getEvmVersion();
    }

    public Optional<Bytes> getChainId() {
        return this.evm.getChainId();
    }
}

