/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.frame;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.collections.trie.BytesTrieSet;
import org.hyperledger.besu.collections.undo.UndoScalar;
import org.hyperledger.besu.collections.undo.UndoSet;
import org.hyperledger.besu.collections.undo.UndoTable;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.VersionedHash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.blockhash.BlockHashLookup;
import org.hyperledger.besu.evm.frame.BlockValues;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.Memory;
import org.hyperledger.besu.evm.frame.TxValues;
import org.hyperledger.besu.evm.internal.MemoryEntry;
import org.hyperledger.besu.evm.internal.OperandStack;
import org.hyperledger.besu.evm.internal.ReturnStack;
import org.hyperledger.besu.evm.internal.StorageEntry;
import org.hyperledger.besu.evm.log.Log;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class MessageFrame {
    public static final int DEFAULT_MAX_STACK_SIZE = 1024;
    private final WorldUpdater worldUpdater;
    private final Type type;
    private State state = State.NOT_STARTED;
    private long gasRemaining;
    private int pc;
    private int section = 0;
    private final Memory memory = new Memory();
    private final OperandStack stack;
    private final Supplier<ReturnStack> returnStack;
    private Bytes output = Bytes.EMPTY;
    private Bytes returnData = Bytes.EMPTY;
    private Code createdCode = null;
    private final boolean isStatic;
    private final List<Log> logs = new ArrayList<Log>();
    private final Map<Address, Wei> refunds = new HashMap<Address, Wei>();
    private final Address recipient;
    private final Address contract;
    private final Bytes inputData;
    private final Address sender;
    private final Wei value;
    private final Wei apparentValue;
    private final Code code;
    private Optional<Bytes> revertReason;
    private final Map<String, Object> contextVariables;
    private Optional<ExceptionalHaltReason> exceptionalHaltReason = Optional.empty();
    private Operation currentOperation;
    private final Consumer<MessageFrame> completer;
    private Optional<MemoryEntry> maybeUpdatedMemory = Optional.empty();
    private Optional<StorageEntry> maybeUpdatedStorage = Optional.empty();
    private final TxValues txValues;
    private final long undoMark;

    public static Builder builder() {
        return new Builder();
    }

    private MessageFrame(Type type, WorldUpdater worldUpdater, long initialGas, Address recipient, Address contract, Bytes inputData, Address sender, Wei value, Wei apparentValue, Code code, boolean isStatic, Consumer<MessageFrame> completer, Map<String, Object> contextVariables, Optional<Bytes> revertReason, TxValues txValues) {
        this.txValues = txValues;
        this.type = type;
        this.worldUpdater = worldUpdater;
        this.gasRemaining = initialGas;
        this.stack = new OperandStack(txValues.maxStackSize());
        this.returnStack = Suppliers.memoize(ReturnStack::new);
        this.pc = code.isValid() ? code.getCodeSection(0).getEntryPoint() : 0;
        this.recipient = recipient;
        this.contract = contract;
        this.inputData = inputData;
        this.sender = sender;
        this.value = value;
        this.apparentValue = apparentValue;
        this.code = code;
        this.isStatic = isStatic;
        this.completer = completer;
        this.contextVariables = contextVariables;
        this.revertReason = revertReason;
        this.undoMark = txValues.transientStorage().mark();
    }

    public int getPC() {
        return this.pc;
    }

    public void setPC(int pc) {
        this.pc = pc;
    }

    public void setSection(int section) {
        this.section = section;
    }

    public int getSection() {
        return this.section;
    }

    public void clearGasRemaining() {
        this.gasRemaining = 0L;
    }

    public long decrementRemainingGas(long amount) {
        this.gasRemaining -= amount;
        return this.gasRemaining;
    }

    public long getRemainingGas() {
        return this.gasRemaining;
    }

    public void incrementRemainingGas(long amount) {
        this.gasRemaining += amount;
    }

    public void setGasRemaining(long amount) {
        this.gasRemaining = amount;
    }

    public Bytes getOutputData() {
        return this.output;
    }

    public void setOutputData(Bytes output) {
        this.output = output;
    }

    public void setCreatedCode(Code createdCode) {
        this.createdCode = createdCode;
    }

    public Code getCreatedCode() {
        return this.createdCode;
    }

    public void clearOutputData() {
        this.setOutputData(Bytes.EMPTY);
    }

    public Bytes getReturnData() {
        return this.returnData;
    }

    public void setReturnData(Bytes returnData) {
        this.returnData = returnData;
    }

    public void clearReturnData() {
        this.setReturnData(Bytes.EMPTY);
    }

    public Bytes getStackItem(int offset) {
        return (Bytes)this.stack.get(offset);
    }

    public Bytes popStackItem() {
        return (Bytes)this.stack.pop();
    }

    public void popStackItems(int n) {
        this.stack.bulkPop(n);
    }

    public void pushStackItem(Bytes value) {
        this.stack.push(value);
    }

    public void setStackItem(int offset, Bytes value) {
        this.stack.set(offset, value);
    }

    public int stackSize() {
        return this.stack.size();
    }

    public int returnStackSize() {
        return this.returnStack.get().size();
    }

    public ReturnStack.ReturnStackItem peekReturnStack() {
        return (ReturnStack.ReturnStackItem)this.returnStack.get().peek();
    }

    public void pushReturnStackItem(ReturnStack.ReturnStackItem returnStackItem) {
        this.returnStack.get().push(returnStackItem);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public long calculateMemoryExpansion(long offset, long length) {
        return this.memory.calculateNewActiveWords(offset, length);
    }

    public void expandMemory(long offset, long length) {
        this.memory.ensureCapacityForBytes(offset, length);
    }

    public long memoryByteSize() {
        return this.memory.getActiveBytes();
    }

    public int memoryWordSize() {
        return this.memory.getActiveWords();
    }

    public Optional<Bytes> getRevertReason() {
        return this.revertReason;
    }

    public void setRevertReason(Bytes revertReason) {
        this.revertReason = Optional.ofNullable(revertReason);
    }

    public MutableBytes readMutableMemory(long offset, long length) {
        return this.readMutableMemory(offset, length, false);
    }

    public Bytes shadowReadMemory(long offset, long length) {
        return this.memory.getBytesWithoutGrowth(offset, length);
    }

    public Bytes readMemory(long offset, long length) {
        return this.readMutableMemory(offset, length, false).copy();
    }

    public MutableBytes readMutableMemory(long offset, long length, boolean explicitMemoryRead) {
        MutableBytes memBytes = this.memory.getMutableBytes(offset, length);
        if (explicitMemoryRead) {
            this.setUpdatedMemory(offset, (Bytes)memBytes);
        }
        return memBytes;
    }

    public void writeMemory(long offset, byte value, boolean explicitMemoryUpdate) {
        this.memory.setByte(offset, value);
        if (explicitMemoryUpdate) {
            this.setUpdatedMemory(offset, Bytes.of((byte[])new byte[]{value}));
        }
    }

    public void writeMemory(long offset, long length, Bytes value) {
        this.writeMemory(offset, length, value, false);
    }

    public void writeMemory(long offset, long length, Bytes value, boolean explicitMemoryUpdate) {
        this.memory.setBytes(offset, length, value);
        if (explicitMemoryUpdate) {
            this.setUpdatedMemory(offset, 0L, length, value);
        }
    }

    public void writeMemoryRightAligned(long offset, long length, Bytes value, boolean explicitMemoryUpdate) {
        this.memory.setBytesRightAligned(offset, length, value);
        if (explicitMemoryUpdate) {
            this.setUpdatedMemoryRightAligned(offset, length, value);
        }
    }

    public void writeMemory(long offset, long sourceOffset, long length, Bytes value) {
        this.writeMemory(offset, sourceOffset, length, value, false);
    }

    public void writeMemory(long offset, long sourceOffset, long length, Bytes value, boolean explicitMemoryUpdate) {
        this.memory.setBytes(offset, sourceOffset, length, value);
        if (explicitMemoryUpdate && length > 0L) {
            this.setUpdatedMemory(offset, sourceOffset, length, value);
        }
    }

    public void copyMemory(long dst, long src, long length, boolean explicitMemoryUpdate) {
        if (length > 0L) {
            this.memory.copy(dst, src, length);
            if (explicitMemoryUpdate) {
                this.setUpdatedMemory(dst, this.memory.getBytes(dst, length));
            }
        }
    }

    private void setUpdatedMemory(long offset, long sourceOffset, long length, Bytes value) {
        long endIndex = sourceOffset + length;
        if (sourceOffset >= 0L && endIndex > 0L) {
            int srcSize = value.size();
            if (endIndex > (long)srcSize) {
                MutableBytes paddedAnswer = MutableBytes.create((int)((int)length));
                if (sourceOffset < (long)srcSize) {
                    value.slice((int)sourceOffset, (int)((long)srcSize - sourceOffset)).copyTo(paddedAnswer, 0);
                }
                this.setUpdatedMemory(offset, paddedAnswer.copy());
            } else {
                this.setUpdatedMemory(offset, value.slice((int)sourceOffset, (int)length).copy());
            }
        }
    }

    private void setUpdatedMemoryRightAligned(long offset, long length, Bytes value) {
        if (length > 0L) {
            int srcSize = value.size();
            if (length > (long)srcSize) {
                MutableBytes paddedAnswer = MutableBytes.create((int)((int)length));
                if (0L < (long)srcSize) {
                    value.slice(0, srcSize).copyTo(paddedAnswer, (int)(length - (long)srcSize));
                }
                this.setUpdatedMemory(offset, paddedAnswer.copy());
            } else {
                this.setUpdatedMemory(offset, value.slice(0, (int)length).copy());
            }
        }
    }

    private void setUpdatedMemory(long offset, Bytes value) {
        this.maybeUpdatedMemory = Optional.of(new MemoryEntry(offset, value));
    }

    public void storageWasUpdated(UInt256 storageAddress, Bytes value) {
        this.maybeUpdatedStorage = Optional.of(new StorageEntry(storageAddress, value));
    }

    public void addLog(Log log) {
        this.logs.add(log);
    }

    public void addLogs(List<Log> logs) {
        this.logs.addAll(logs);
    }

    public void clearLogs() {
        this.logs.clear();
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public void incrementGasRefund(long amount) {
        this.txValues.gasRefunds().set(this.txValues.gasRefunds().get() + amount);
    }

    public void clearGasRefund() {
        this.txValues.gasRefunds().set(0L);
    }

    public long getGasRefund() {
        return this.txValues.gasRefunds().get();
    }

    public void addSelfDestruct(Address address) {
        this.txValues.selfDestructs().add(address);
    }

    public void addSelfDestructs(Set<Address> addresses) {
        this.txValues.selfDestructs().addAll((Collection<Address>)addresses);
    }

    public Set<Address> getSelfDestructs() {
        return this.txValues.selfDestructs();
    }

    public void addCreate(Address address) {
        this.txValues.creates().add(address);
    }

    public void addCreates(Set<Address> addresses) {
        this.txValues.creates().addAll((Collection<Address>)addresses);
    }

    public Set<Address> getCreates() {
        return this.txValues.creates();
    }

    public boolean wasCreatedInTransaction(Address address) {
        return this.txValues.creates().contains(address);
    }

    public void addRefund(Address beneficiary, Wei amount) {
        this.refunds.put(beneficiary, amount);
    }

    public Map<Address, Wei> getRefunds() {
        return this.refunds;
    }

    public boolean warmUpAddress(Address address) {
        return !this.txValues.warmedUpAddresses().add(address);
    }

    public boolean isAddressWarm(Address address) {
        return this.txValues.warmedUpAddresses().contains(address);
    }

    public boolean warmUpStorage(Address address, Bytes32 slot) {
        return this.txValues.warmedUpStorage().put(address, slot, Boolean.TRUE) != null;
    }

    public WorldUpdater getWorldUpdater() {
        return this.worldUpdater;
    }

    public Type getType() {
        return this.type;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Code getCode() {
        return this.code;
    }

    public Bytes getInputData() {
        return this.inputData;
    }

    public Address getRecipientAddress() {
        return this.recipient;
    }

    public int getMessageStackSize() {
        return this.txValues.messageFrameStack().size();
    }

    public int getDepth() {
        return this.getMessageStackSize() - 1;
    }

    public Address getOriginatorAddress() {
        return this.txValues.originator();
    }

    public Address getContractAddress() {
        return this.contract;
    }

    public Wei getGasPrice() {
        return this.txValues.gasPrice();
    }

    public Wei getBlobGasPrice() {
        return this.txValues.blobGasPrice();
    }

    public Address getSenderAddress() {
        return this.sender;
    }

    public Wei getValue() {
        return this.value;
    }

    public Wei getApparentValue() {
        return this.apparentValue;
    }

    public BlockValues getBlockValues() {
        return this.txValues.blockValues();
    }

    public void notifyCompletion() {
        this.completer.accept(this);
    }

    public Deque<MessageFrame> getMessageFrameStack() {
        return this.txValues.messageFrameStack();
    }

    public ReturnStack getReturnStack() {
        return this.returnStack.get();
    }

    public void setExceptionalHaltReason(Optional<ExceptionalHaltReason> exceptionalHaltReason) {
        this.exceptionalHaltReason = exceptionalHaltReason;
    }

    public Optional<ExceptionalHaltReason> getExceptionalHaltReason() {
        return this.exceptionalHaltReason;
    }

    public Address getMiningBeneficiary() {
        return this.txValues.miningBeneficiary();
    }

    public BlockHashLookup getBlockHashLookup() {
        return this.txValues.blockHashLookup();
    }

    public Operation getCurrentOperation() {
        return this.currentOperation;
    }

    public int getMaxStackSize() {
        return this.txValues.maxStackSize();
    }

    public <T> T getContextVariable(String name) {
        return (T)this.contextVariables.get(name);
    }

    public <T> T getContextVariable(String name, T defaultValue) {
        return (T)this.contextVariables.getOrDefault(name, defaultValue);
    }

    public boolean hasContextVariable(String name) {
        return this.contextVariables.containsKey(name);
    }

    public void setCurrentOperation(Operation currentOperation) {
        this.currentOperation = currentOperation;
    }

    public Table<Address, Bytes32, Boolean> getWarmedUpStorage() {
        return this.txValues.warmedUpStorage();
    }

    public Optional<MemoryEntry> getMaybeUpdatedMemory() {
        return this.maybeUpdatedMemory;
    }

    public Optional<StorageEntry> getMaybeUpdatedStorage() {
        return this.maybeUpdatedStorage;
    }

    public Bytes32 getTransientStorageValue(Address accountAddress, Bytes32 slot) {
        Bytes32 v = this.txValues.transientStorage().get(accountAddress, slot);
        return v == null ? Bytes32.ZERO : v;
    }

    public void setTransientStorageValue(Address accountAddress, Bytes32 slot, Bytes32 value) {
        this.txValues.transientStorage().put(accountAddress, slot, value);
    }

    public void rollback() {
        this.txValues.undoChanges(this.undoMark);
    }

    public Optional<List<VersionedHash>> getVersionedHashes() {
        return this.txValues.versionedHashes();
    }

    public void reset() {
        this.maybeUpdatedMemory = Optional.empty();
        this.maybeUpdatedStorage = Optional.empty();
    }

    public static class Builder {
        private MessageFrame parentMessageFrame;
        private Type type;
        private WorldUpdater worldUpdater;
        private Long initialGas;
        private Address address;
        private Address originator;
        private Address contract;
        private Wei gasPrice;
        private Wei blobGasPrice = Wei.ZERO;
        private Bytes inputData;
        private Address sender;
        private Wei value;
        private Wei apparentValue;
        private Code code;
        private BlockValues blockValues;
        private int maxStackSize = 1024;
        private boolean isStatic = false;
        private Consumer<MessageFrame> completer;
        private Address miningBeneficiary;
        private BlockHashLookup blockHashLookup;
        private Map<String, Object> contextVariables;
        private Optional<Bytes> reason = Optional.empty();
        private Set<Address> accessListWarmAddresses = Collections.emptySet();
        private Multimap<Address, Bytes32> accessListWarmStorage = HashMultimap.create();
        private Optional<List<VersionedHash>> versionedHashes = Optional.empty();

        public Builder parentMessageFrame(MessageFrame parentMessageFrame) {
            this.parentMessageFrame = parentMessageFrame;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder worldUpdater(WorldUpdater worldUpdater) {
            this.worldUpdater = worldUpdater;
            return this;
        }

        public Builder initialGas(long initialGas) {
            this.initialGas = initialGas;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder originator(Address originator) {
            this.originator = originator;
            return this;
        }

        public Builder contract(Address contract) {
            this.contract = contract;
            return this;
        }

        public Builder gasPrice(Wei gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public Builder blobGasPrice(Wei blobGasPrice) {
            this.blobGasPrice = blobGasPrice;
            return this;
        }

        public Builder inputData(Bytes inputData) {
            this.inputData = inputData;
            return this;
        }

        public Builder sender(Address sender) {
            this.sender = sender;
            return this;
        }

        public Builder value(Wei value) {
            this.value = value;
            return this;
        }

        public Builder apparentValue(Wei apparentValue) {
            this.apparentValue = apparentValue;
            return this;
        }

        public Builder code(Code code) {
            this.code = code;
            return this;
        }

        public Builder blockValues(BlockValues blockValues) {
            this.blockValues = blockValues;
            return this;
        }

        public Builder isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        public Builder maxStackSize(int maxStackSize) {
            this.maxStackSize = maxStackSize;
            return this;
        }

        public Builder completer(Consumer<MessageFrame> completer) {
            this.completer = completer;
            return this;
        }

        public Builder miningBeneficiary(Address miningBeneficiary) {
            this.miningBeneficiary = miningBeneficiary;
            return this;
        }

        public Builder blockHashLookup(BlockHashLookup blockHashLookup) {
            this.blockHashLookup = blockHashLookup;
            return this;
        }

        public Builder contextVariables(Map<String, Object> contextVariables) {
            this.contextVariables = contextVariables;
            return this;
        }

        public Builder reason(Bytes reason) {
            this.reason = Optional.ofNullable(reason);
            return this;
        }

        public Builder accessListWarmAddresses(Set<Address> accessListWarmAddresses) {
            this.accessListWarmAddresses = accessListWarmAddresses;
            return this;
        }

        public Builder accessListWarmStorage(Multimap<Address, Bytes32> accessListWarmStorage) {
            this.accessListWarmStorage = accessListWarmStorage;
            return this;
        }

        public Builder versionedHashes(Optional<List<VersionedHash>> versionedHashes) {
            this.versionedHashes = versionedHashes;
            return this;
        }

        private void validate() {
            if (this.parentMessageFrame == null) {
                Preconditions.checkState((this.worldUpdater != null ? 1 : 0) != 0, (Object)"Missing message frame world updater");
                Preconditions.checkState((this.originator != null ? 1 : 0) != 0, (Object)"Missing message frame originator");
                Preconditions.checkState((this.gasPrice != null ? 1 : 0) != 0, (Object)"Missing message frame getGasRemaining price");
                Preconditions.checkState((this.blobGasPrice != null ? 1 : 0) != 0, (Object)"Missing message frame blob gas price");
                Preconditions.checkState((this.blockValues != null ? 1 : 0) != 0, (Object)"Missing message frame block header");
                Preconditions.checkState((this.miningBeneficiary != null ? 1 : 0) != 0, (Object)"Missing mining beneficiary");
                Preconditions.checkState((this.blockHashLookup != null ? 1 : 0) != 0, (Object)"Missing block hash lookup");
            }
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"Missing message frame type");
            Preconditions.checkState((this.initialGas != null ? 1 : 0) != 0, (Object)"Missing message frame initial getGasRemaining");
            Preconditions.checkState((this.address != null ? 1 : 0) != 0, (Object)"Missing message frame recipient");
            Preconditions.checkState((this.contract != null ? 1 : 0) != 0, (Object)"Missing message frame contract");
            Preconditions.checkState((this.inputData != null ? 1 : 0) != 0, (Object)"Missing message frame input data");
            Preconditions.checkState((this.sender != null ? 1 : 0) != 0, (Object)"Missing message frame sender");
            Preconditions.checkState((this.value != null ? 1 : 0) != 0, (Object)"Missing message frame value");
            Preconditions.checkState((this.apparentValue != null ? 1 : 0) != 0, (Object)"Missing message frame apparent value");
            Preconditions.checkState((this.code != null ? 1 : 0) != 0, (Object)"Missing message frame code");
            Preconditions.checkState((this.completer != null ? 1 : 0) != 0, (Object)"Missing message frame completer");
        }

        public MessageFrame build() {
            boolean newStatic;
            WorldUpdater updater;
            TxValues newTxValues;
            this.validate();
            if (this.parentMessageFrame == null) {
                newTxValues = new TxValues(this.blockHashLookup, this.maxStackSize, UndoSet.of(new BytesTrieSet(20)), UndoTable.of(HashBasedTable.create()), this.originator, this.gasPrice, this.blobGasPrice, this.blockValues, new ArrayDeque<MessageFrame>(), this.miningBeneficiary, this.versionedHashes, UndoTable.of(HashBasedTable.create()), UndoSet.of(new BytesTrieSet(20)), UndoSet.of(new BytesTrieSet(20)), new UndoScalar<Long>(0L));
                updater = this.worldUpdater;
                newStatic = this.isStatic;
            } else {
                newTxValues = this.parentMessageFrame.txValues;
                updater = this.parentMessageFrame.getWorldUpdater().updater();
                newStatic = this.isStatic || this.parentMessageFrame.isStatic;
                this.parentMessageFrame.warmUpAddress(this.contract);
            }
            MessageFrame messageFrame = new MessageFrame(this.type, updater, this.initialGas, this.address, this.contract, this.inputData, this.sender, this.value, this.apparentValue, this.code, newStatic, this.completer, this.contextVariables == null ? Map.of() : this.contextVariables, this.reason, newTxValues);
            newTxValues.messageFrameStack().addFirst(messageFrame);
            messageFrame.warmUpAddress(this.sender);
            messageFrame.warmUpAddress(this.contract);
            for (Address a : this.accessListWarmAddresses) {
                messageFrame.warmUpAddress(a);
            }
            for (Map.Entry e : this.accessListWarmStorage.entries()) {
                messageFrame.warmUpStorage((Address)e.getKey(), (Bytes32)e.getValue());
            }
            return messageFrame;
        }
    }

    public static enum State {
        NOT_STARTED,
        CODE_EXECUTING,
        CODE_SUCCESS,
        CODE_SUSPENDED,
        EXCEPTIONAL_HALT,
        REVERT,
        COMPLETED_FAILED,
        COMPLETED_SUCCESS;

    }

    public static enum Type {
        CONTRACT_CREATION,
        MESSAGE_CALL;

    }
}

